/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.commons.crypto;

import cn.hutool.core.util.HexUtil;
import cn.hutool.crypto.SecureUtil;
import com.digiwin.dap.middleware.commons.core.codec.Base64;
import com.digiwin.dap.middleware.commons.crypto.constant.AlgorithmEnum;
import com.digiwin.dap.middleware.commons.crypto.constant.TransformationEnum;
import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.exception.CommonException;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AES {
    private static final int KEY_LEN = 16;
    private static final int IV_SIZE = 16;
    private static final byte[] IV = StrUtils.bytes("ghUb#er57HBh(u%g");

    private AES() {
    }

    public static String encrypt(String data, String key) {
        return AES.encrypt(data, StrUtils.bytes(key));
    }

    public static String decrypt(String data, String key) {
        return AES.decrypt(data, StrUtils.bytes(key));
    }

    public static String encrypt(String data, byte[] key) {
        byte[] bytes = SecureUtil.aes((byte[])key).encrypt(data);
        return Base64.encode(bytes);
    }

    public static String decrypt(String data, byte[] key) {
        byte[] decode64 = Base64.decode(data);
        byte[] bytes = SecureUtil.aes((byte[])key).decrypt(decode64);
        return StrUtils.str(bytes);
    }

    public static String encryptHex(String data, String key) {
        byte[] finalKey = AES.paddingKey(key);
        byte[] bytes = SecureUtil.aes((byte[])finalKey).encrypt(data);
        char[] encodeHex = HexUtil.encodeHex((byte[])bytes, (boolean)false);
        return new String(encodeHex);
    }

    public static String decryptHex(String data, String key) {
        byte[] finalKey = AES.paddingKey(key);
        byte[] decodeHex = HexUtil.decodeHex((char[])data.toCharArray());
        byte[] bytes = SecureUtil.aes((byte[])finalKey).decrypt(decodeHex);
        return StrUtils.str(bytes);
    }

    public static String encryptCBC(String data, String key) {
        return AES.encryptCBC(data, key, IV);
    }

    public static String decryptCBC(String data, String key) {
        return AES.decryptCBC(data, key, IV);
    }

    public static String encryptCBC(String data, String key, byte[] iv) {
        byte[] bytes = StrUtils.bytes(data);
        byte[] finalKey = AES.paddingKey(key);
        return Base64.encode(AES.encrypt(bytes, finalKey, TransformationEnum.AES_CBC_PKCS5PADDING.getValue(), iv));
    }

    public static String decryptCBC(String data, String key, byte[] iv) {
        byte[] bytes = Base64.decode(data);
        byte[] finalKey = AES.paddingKey(key);
        return StrUtils.str(AES.decrypt(bytes, finalKey, TransformationEnum.AES_CBC_PKCS5PADDING.getValue(), iv));
    }

    public static byte[] encrypt(byte[] data, byte[] key, String transformation, byte[] iv) {
        try {
            SecretKeySpec spec = new SecretKeySpec(key, AlgorithmEnum.AES.getValue());
            Cipher cipher = Cipher.getInstance(transformation);
            if (iv != null) {
                IvParameterSpec params = new IvParameterSpec(iv);
                cipher.init(1, (Key)spec, params);
            } else {
                cipher.init(1, spec);
            }
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new CommonException("AES\u52a0\u5bc6\u5f02\u5e38", e);
        }
    }

    public static byte[] decrypt(byte[] data, byte[] key, String transformation, byte[] iv) {
        try {
            SecretKeySpec spec = new SecretKeySpec(key, AlgorithmEnum.AES.getValue());
            Cipher cipher = Cipher.getInstance(transformation);
            if (iv != null) {
                IvParameterSpec params = new IvParameterSpec(iv);
                cipher.init(2, (Key)spec, params);
            } else {
                cipher.init(2, spec);
            }
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new CommonException("AES\u89e3\u5bc6\u5f02\u5e38", e);
        }
    }

    public static String encryptIvCBC(String data, String key) {
        byte[] bytes = StrUtils.bytes(data);
        byte[] finalKey = AES.paddingKey(key);
        return Base64.encode(AES.encryptIvCBC(bytes, finalKey));
    }

    public static String decryptIvCBC(String data, String key) {
        byte[] bytes = Base64.decode(data);
        byte[] finalKey = AES.paddingKey(key);
        return StrUtils.str(AES.decryptIvCBC(bytes, finalKey));
    }

    public static byte[] encryptIvCBC(byte[] data, byte[] key) {
        return AES.encryptIv(data, key, TransformationEnum.AES_CBC_PKCS5PADDING.getValue());
    }

    public static byte[] decryptIvCBC(byte[] data, byte[] key) {
        return AES.decryptIv(data, key, TransformationEnum.AES_CBC_PKCS5PADDING.getValue());
    }

    private static byte[] encryptIv(byte[] data, byte[] key, String transformation) {
        try {
            byte[] iv = new byte[16];
            SecureRandom random = new SecureRandom();
            random.nextBytes(iv);
            IvParameterSpec params = new IvParameterSpec(iv);
            SecretKeySpec secretKeySpec = new SecretKeySpec(key, AlgorithmEnum.AES.getValue());
            Cipher cipher = Cipher.getInstance(transformation);
            cipher.init(1, (Key)secretKeySpec, params);
            byte[] encrypted = cipher.doFinal(data);
            byte[] combined = new byte[iv.length + encrypted.length];
            System.arraycopy(iv, 0, combined, 0, iv.length);
            System.arraycopy(encrypted, 0, combined, iv.length, encrypted.length);
            return combined;
        }
        catch (Exception e) {
            throw new CommonException("AES\u52a0\u5bc6\u5f02\u5e38", e);
        }
    }

    private static byte[] decryptIv(byte[] data, byte[] key, String transformation) {
        try {
            IvParameterSpec params = new IvParameterSpec(data, 0, 16);
            SecretKeySpec secretKeySpec = new SecretKeySpec(key, AlgorithmEnum.AES.getValue());
            Cipher cipher = Cipher.getInstance(transformation);
            cipher.init(2, (Key)secretKeySpec, params);
            return cipher.doFinal(data, 16, data.length - 16);
        }
        catch (Exception e) {
            throw new CommonException("AES\u89e3\u5bc6\u5f02\u5e38", e);
        }
    }

    public static byte[] paddingKey(String key) {
        if (key == null) {
            throw new CommonException("AES key\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (key.length() == 16) {
            return StrUtils.bytes(key);
        }
        byte[] finalKey = new byte[16];
        int i = 0;
        for (byte b : StrUtils.bytes(key)) {
            int n = i++ % 16;
            finalKey[n] = (byte)(finalKey[n] ^ b);
        }
        return finalKey;
    }

    public static byte[] generateKey(int keySize) {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(AlgorithmEnum.AES.getValue());
            keyGenerator.init(keySize);
            return keyGenerator.generateKey().getEncoded();
        }
        catch (Exception e) {
            throw new CommonException("\u83b7\u53d6AES\u5bc6\u94a5\u5f02\u5e38,\u5bc6\u94a5\u957f\u5ea6:" + keySize, e);
        }
    }
}

