/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Date;

public class DateUtils {
    public static final String PATTERN_DATETIME = "yyyy-MM-dd HH:mm:ss";
    public static final String PATTERN_DATE = "yyyy-MM-dd";
    public static final String PATTERN_TIME = "HH:mm:ss";
    public static final String PATTERN_PURE_DATETIME = "yyyyMMddHHmmss";
    public static final String PATTERN_PURE_DATE = "yyyyMMdd";
    public static final String PATTERN_PURE_TIME = "HHmmss";
    public static final String PATTERN_PATTERN_NORM_DATETIME_MS = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String PATTERN_PURE_DATETIME_MS = "yyyyMMddHHmmssSSS";

    public static LocalDateTime getDateByStr(String dateStr) {
        return DateUtils.getDateByStr(dateStr, PATTERN_DATETIME);
    }

    public static LocalDateTime getDateByStr(String dateStr, String formatter) {
        if (dateStr == null) {
            return null;
        }
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(formatter);
        return LocalDateTime.parse(dateStr, dtf);
    }

    public static LocalDateTime now() {
        return LocalDateTime.now();
    }

    public static String formatDateTime(Date date) {
        return DateUtils.format(date, PATTERN_DATETIME);
    }

    public static String formatDate(Date date) {
        return DateUtils.format(date, PATTERN_DATE);
    }

    public static String formatTime(Date date) {
        return DateUtils.format(date, PATTERN_TIME);
    }

    public static String format(Date date, String pattern) {
        return new SimpleDateFormat(pattern).format(date);
    }

    public static String formatDateTime(TemporalAccessor temporal) {
        return DateUtils.format(temporal, PATTERN_DATETIME);
    }

    public static String formatDate(TemporalAccessor temporal) {
        return DateUtils.format(temporal, PATTERN_DATE);
    }

    public static String formatTime(TemporalAccessor temporal) {
        return DateUtils.format(temporal, PATTERN_TIME);
    }

    public static String formatDateTimePure(TemporalAccessor temporal) {
        return DateUtils.format(temporal, PATTERN_PURE_DATETIME);
    }

    public static String formatDatePure(TemporalAccessor temporal) {
        return DateUtils.format(temporal, PATTERN_PURE_DATE);
    }

    public static String formatTimePure(TemporalAccessor temporal) {
        return DateUtils.format(temporal, PATTERN_PURE_TIME);
    }

    public static String formatDateTimeMsNorm(TemporalAccessor temporal) {
        return DateUtils.format(temporal, PATTERN_PATTERN_NORM_DATETIME_MS);
    }

    public static String formatDateTimeMsPure(TemporalAccessor temporal) {
        return DateUtils.format(temporal, PATTERN_PURE_DATETIME_MS);
    }

    public static String format(TemporalAccessor temporal, String pattern) {
        return DateTimeFormatter.ofPattern(pattern).format(temporal);
    }

    public static Date parseDateTime(String dateStr) {
        return DateUtils.parse(dateStr, PATTERN_DATETIME);
    }

    public static Date parseDate(String dateStr) {
        return DateUtils.parse(dateStr, PATTERN_DATE);
    }

    public static Date parseTime(String dateStr) {
        return DateUtils.parse(dateStr, PATTERN_TIME);
    }

    public static Date parse(String dateStr, String pattern) {
        return DateUtils.parse(dateStr, new SimpleDateFormat(pattern));
    }

    public static Date parse(String dateStr, DateFormat format) {
        try {
            return format.parse(dateStr);
        }
        catch (ParseException e) {
            throw new RuntimeException("\u65e5\u671f\u65f6\u95f4\u8f6c\u5316\u5931\u8d25", e);
        }
    }

    public static LocalDateTime parseLocalDateTime(String dateStr) {
        return DateUtils.parseLocalDateTime(dateStr, PATTERN_DATETIME);
    }

    public static LocalDateTime parseLocalDate(String dateStr) {
        return DateUtils.parseLocalDateTime(dateStr, PATTERN_DATE);
    }

    public static LocalDateTime parseLocalTime(String dateStr) {
        return DateUtils.parseLocalDateTime(dateStr, PATTERN_TIME);
    }

    public static LocalDateTime parseLocalDateTime(String dateStr, String pattern) {
        return DateUtils.parseLocalDateTime(dateStr, DateTimeFormatter.ofPattern(pattern));
    }

    public static LocalDateTime parseLocalDateTime(String dateStr, DateTimeFormatter formatter) {
        return LocalDateTime.parse(dateStr, formatter);
    }

    public static Instant toInstant(LocalDateTime dateTime) {
        return dateTime.atZone(ZoneId.systemDefault()).toInstant();
    }

    public static LocalDateTime toDateTime(Instant instant) {
        return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
    }

    public static Date toDate(LocalDateTime dateTime) {
        return Date.from(DateUtils.toInstant(dateTime));
    }

    public static Date toDate(LocalDate localDate) {
        return Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    public static long toMilliseconds(LocalDateTime localDateTime) {
        return localDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static long toMilliseconds(LocalDate localDate) {
        return DateUtils.toMilliseconds(localDate.atStartOfDay());
    }

    public static LocalDateTime toDateTime(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
    }

    public static LocalDateTime toDateTime(long milliseconds) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(milliseconds), ZoneId.systemDefault());
    }

    public static Duration between(LocalDateTime startTimeInclude, LocalDateTime endTimeExclude) {
        return Duration.between(startTimeInclude, endTimeExclude);
    }

    public static Period between(LocalDate startTimeInclude, LocalDate endTimeExclude) {
        return Period.between(startTimeInclude, endTimeExclude);
    }

    public static Duration between(Date startDate, Date endDate) {
        return Duration.between(startDate.toInstant(), endDate.toInstant());
    }

    public static LocalDateTime beginOfDay(LocalDateTime time) {
        return time.with(LocalTime.MIN);
    }

    public static LocalDateTime endOfDay(LocalDateTime time) {
        return time.with(LocalTime.of(23, 59, 59));
    }

    public static boolean isWeekend(LocalDateTime localDateTime) {
        return DateUtils.isWeekend(localDateTime.toLocalDate());
    }

    public static boolean isWeekend(LocalDate localDate) {
        DayOfWeek dayOfWeek = localDate.getDayOfWeek();
        return DayOfWeek.SATURDAY == dayOfWeek || DayOfWeek.SUNDAY == dayOfWeek;
    }

    public static boolean isOverlap(ChronoLocalDateTime<?> realStartTime, ChronoLocalDateTime<?> realEndTime, ChronoLocalDateTime<?> startTime, ChronoLocalDateTime<?> endTime) {
        return startTime.isAfter(realEndTime) || endTime.isBefore(realStartTime);
    }
}

