/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.commons.crypto;

import cn.hutool.crypto.digest.DigestAlgorithm;
import cn.hutool.crypto.digest.DigestUtil;
import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.digiwin.dap.middleware.commons.core.codec.Base64;
import com.digiwin.dap.middleware.commons.util.StrUtils;
import java.security.MessageDigest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigestUtils {
    private static final Logger logger = LoggerFactory.getLogger(DigestUtils.class);

    private DigestUtils() {
    }

    public static String sha256(String data) {
        return DigestUtils.sha256(data, 2);
    }

    public static String sha256(String data, int count) {
        byte[] digest = StrUtils.bytes(data);
        for (int i = 0; i < count; ++i) {
            digest = DigestUtil.sha256((byte[])digest);
        }
        return Base64.encode(digest);
    }

    public static String md5Hex(String data) {
        return DigestUtil.md5Hex((byte[])StrUtils.bytes(data));
    }

    public static String md5(String data, String salt) {
        try {
            MessageDigest digest = MessageDigest.getInstance(DigestAlgorithm.MD5.getValue());
            digest.update(Base64.decode(salt));
            byte[] bytes = digest.digest(data.getBytes());
            StringBuilder sb = new StringBuilder();
            for (byte aByte : bytes) {
                sb.append(String.format("%02x", aByte));
            }
            return sb.toString();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String md5(byte[] data) {
        try {
            MessageDigest md = MessageDigest.getInstance(DigestAlgorithm.MD5.getValue());
            md.reset();
            md.update(data);
            byte[] digest = md.digest();
            return Base64.encode(digest);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String getAppToken(String sysId, String key) {
        Algorithm algorithm = Algorithm.HMAC256((String)key);
        return JWT.create().withClaim("id", sysId).withClaim("sid", Long.valueOf(0L)).sign(algorithm);
    }
}

