/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.commons.crypto.constant;

import java.util.Objects;

public enum AlgorithmEnum {
    AES(true, "AES"),
    RSA(false, "RSA");

    private final Boolean symmetry;
    private final String value;

    private AlgorithmEnum(Boolean symmetry, String value) {
        this.symmetry = symmetry;
        this.value = value;
    }

    public Boolean getSymmetry() {
        return this.symmetry;
    }

    public String getValue() {
        return this.value;
    }

    public static AlgorithmEnum getByValue(String value) {
        for (AlgorithmEnum algorithmEnum : AlgorithmEnum.values()) {
            if (!Objects.equals(value, algorithmEnum.getValue())) continue;
            return algorithmEnum;
        }
        return null;
    }
}

