/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EntityUtils {
    private static final Logger logger = LoggerFactory.getLogger(EntityUtils.class);

    private EntityUtils() {
    }

    public static <T> List<T> castEntity(List<Object[]> list, Class<T> clazz, Object model) {
        ArrayList<T> returnList = new ArrayList<T>();
        if (list.isEmpty()) {
            return returnList;
        }
        Object[] co = list.get(0);
        List<Map> attributeInfoList = EntityUtils.getFieldsInfo(model);
        Class[] c2 = new Class[attributeInfoList.size()];
        if (attributeInfoList.size() != co.length) {
            return returnList;
        }
        for (int i = 0; i < attributeInfoList.size(); ++i) {
            c2[i] = (Class)attributeInfoList.get(i).get("type");
        }
        try {
            for (Object[] o : list) {
                Constructor<T> constructor = clazz.getConstructor(c2);
                returnList.add(constructor.newInstance(o));
            }
        }
        catch (Exception ex) {
            logger.error("\u5b9e\u4f53\u6570\u636e\u8f6c\u5316\u4e3a\u5b9e\u4f53\u7c7b\u53d1\u751f\u5f02\u5e38\uff1a\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)ex.getMessage());
            return returnList;
        }
        return returnList;
    }

    private static Object getFieldValueByName(String fieldName, Object modle) {
        try {
            String firstLetter = fieldName.substring(0, 1).toUpperCase();
            String getter = "get" + firstLetter + fieldName.substring(1);
            Method method = modle.getClass().getMethod(getter, new Class[0]);
            return method.invoke(modle, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static List<Map> getFieldsInfo(Object model) {
        Field[] fields = model.getClass().getDeclaredFields();
        ArrayList<Map> list = new ArrayList<Map>(fields.length);
        HashMap<String, Object> infoMap = null;
        for (int i = 0; i < fields.length; ++i) {
            infoMap = new HashMap<String, Object>(3);
            infoMap.put("type", fields[i].getType());
            infoMap.put("name", fields[i].getName());
            infoMap.put("value", EntityUtils.getFieldValueByName(fields[i].getName(), model));
            list.add(infoMap);
        }
        return list;
    }
}

