/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.util;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ObjectCopyUtil {
    private ObjectCopyUtil() {
    }

    public static List<Field> getFields(Object object) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> aClass = object.getClass(); aClass != null; aClass = aClass.getSuperclass()) {
            Field[] declaredFields = aClass.getDeclaredFields();
            Arrays.stream(declaredFields).filter(field -> !field.isSynthetic() && !Modifier.isStatic(field.getModifiers())).forEach(fields::add);
        }
        return fields;
    }

    public static void mergeObject(Object origin, Object destination) {
        if (origin == null || destination == null) {
            return;
        }
        if (!origin.getClass().equals(destination.getClass())) {
            return;
        }
        List<Field> fieldList = ObjectCopyUtil.getFields(origin);
        for (Field field : fieldList) {
            field.setAccessible(true);
            try {
                Object value = field.get(origin);
                if (null != value) {
                    field.set(destination, value);
                }
                field.setAccessible(false);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("\u5bf9\u8c61\u5408\u5e76\u9519\u8bef\uff01", e);
            }
        }
    }

    public static void mergeDifferentTypeObject(Object origin, Object destination) {
        if (origin == null || destination == null) {
            return;
        }
        List<Field> originFieldList = ObjectCopyUtil.getFields(origin);
        List<Field> destinationFieldList = ObjectCopyUtil.getFields(destination);
        for (Field origField : originFieldList) {
            for (Field destField : destinationFieldList) {
                if (!origField.getName().equals(destField.getName())) continue;
                origField.setAccessible(true);
                destField.setAccessible(true);
                try {
                    Object value = origField.get(origin);
                    JsonIgnore jsonIgnore = origField.getAnnotation(JsonIgnore.class);
                    if (jsonIgnore == null && value != null) {
                        destField.set(destination, value);
                    }
                    origField.setAccessible(false);
                    destField.setAccessible(false);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("\u5bf9\u8c61\u590d\u5236\u9519\u8bef", e);
                }
            }
        }
    }
}

