/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionUtils {
    private static final Logger logger = LoggerFactory.getLogger(ReflectionUtils.class);

    private ReflectionUtils() {
    }

    public static Method getDeclaredMethod(Object object, String methodName, Class<?> ... parameterTypes) {
        Method method = null;
        for (Class<?> clazz = object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                method = clazz.getDeclaredMethod(methodName, parameterTypes);
                return method;
            }
            catch (NoSuchMethodException | SecurityException e) {
                logger.error(e.getMessage(), (Throwable)e);
                continue;
            }
        }
        return null;
    }

    public static Object invokeMethod(Object object, String methodName, Class<?>[] parameterTypes, Object[] parameters) {
        Method method = ReflectionUtils.getDeclaredMethod(object, methodName, parameterTypes);
        try {
            if (method != null) {
                method.setAccessible(true);
                return method.invoke(object, parameters);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static List<Field> getDeclaredFields(Class<?> clazz) {
        ArrayList<Field> result = new ArrayList<Field>();
        Field[] fields = clazz.getDeclaredFields();
        Collections.addAll(result, fields);
        Class<?> superClass = clazz.getSuperclass();
        if (superClass == Object.class) {
            return result;
        }
        List<Field> superFields = ReflectionUtils.getDeclaredFields(superClass);
        result.addAll(superFields);
        return result;
    }

    public static Field getDeclaredField(Class<?> clazz, String fieldName) {
        Field field = null;
        try {
            field = clazz.getDeclaredField(fieldName);
            return field;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Class<?> superClass = clazz.getSuperclass();
            if (superClass == Object.class) {
                return null;
            }
            try {
                field = ReflectionUtils.getDeclaredField(superClass, fieldName);
                if (field != null) {
                    return field;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    public static void setFieldValue(Object object, String fieldName, Object value) {
        try {
            Field field = ReflectionUtils.getDeclaredField(object.getClass(), fieldName);
            if (field != null) {
                field.setAccessible(true);
                field.set(object, value);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static Object getFieldValue(Object object, String fieldName) {
        try {
            Field field = ReflectionUtils.getDeclaredField(object.getClass(), fieldName);
            if (field != null) {
                field.setAccessible(true);
                return field.get(object);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }
}

