package com.digiwin.dap.middleware.commons.crypto;

import com.digiwin.dap.middleware.commons.crypto.domain.DapEncryptDTO;
import com.digiwin.dap.middleware.util.JsonUtils;

/**
 * 加密工具类
 * 中间件接口加密请求参数加密处理
 */
public class EncryptUtils {
    /**
     * 加密方法，将请求对象根据密钥进行加密处理，返回加密对象
     * @param key 加密密钥
     * @param data   加密对象
     * @return       对象加密之后生成的加密字符串
     */
    public static String encrypt(String key,Object data){
        String dataStr= JsonUtils.objToJson(data);
        String eData=AES.encryptIvCBC(dataStr,key);
        return eData;
    }

    /**
     * 解密加密对象
     * @param key 解密密钥
     * @param eData 加密对象
     * @param targetType 解密对象
     * @return           加密字符串解密之后的对象
     * @param <T>
     */
    public static <T> T getDecryptData(String key,String eData, Class<T> targetType){
        String data = AES.decryptIvCBC(eData, key);
        return JsonUtils.jsonToObj(data, targetType);
    }



}
