/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.console.domain.admin;

import com.digiwin.dap.middle.console.domain.admin.SqlTableRule;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class SqlRule {
    private final Map<String, SqlTableRule> tables = new HashMap<String, SqlTableRule>();
    private final Set<String> functions = new HashSet<String>();
    private final Set<String> withs = new HashSet<String>();

    public SqlRule table(String table, String ... cols) {
        String tableLowerCase = table.toLowerCase();
        if (this.tables.containsKey(tableLowerCase)) {
            this.tables.get(tableLowerCase).columns(cols);
        } else {
            SqlTableRule SQLTableRule = new SqlTableRule();
            SQLTableRule.columns(cols);
            this.tables.put(tableLowerCase, SQLTableRule);
        }
        return this;
    }

    public SqlRule functions(String ... funs) {
        this.functions.addAll(Arrays.stream(funs).map(String::toUpperCase).collect(Collectors.toList()));
        return this;
    }

    public SqlRule with(String with) {
        this.withs.add(with);
        return this;
    }

    public boolean containsTable(String table) {
        return this.tables.containsKey(table.toLowerCase());
    }

    public boolean containsColumn(String table, String column) {
        return this.tables.get(table.toLowerCase()).getColumns().contains(column.toLowerCase());
    }

    public boolean containsFunction(String function) {
        return this.functions.contains(function.toUpperCase());
    }

    public boolean containsWith(String with) {
        return this.withs.contains(with.toLowerCase());
    }

    public String toString() {
        return "\u5171 " + this.tables.size() + " \u5f20\u8868\uff0c" + this.functions.size() + " \u4e2a\u51fd\u6570\u3002";
    }
}

