/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.console.serice;

import com.digiwin.dap.middle.console.domain.admin.SqlRule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.WithItem;

public class SqlSafeValidator {
    private static final String SUBSELECT = "<SUBSELECT>";
    private final SqlRule sqlRule;

    private SqlSafeValidator(SqlRule sqlRule) {
        this.sqlRule = sqlRule;
    }

    public static SqlSafeValidator build(SqlRule sqlRule) {
        return new SqlSafeValidator(sqlRule);
    }

    public void validate(String sql) {
        try {
            Statement statement = CCJSqlParserUtil.parse((String)sql);
            if (!(statement instanceof Select)) {
                throw new IllegalArgumentException("\u4ec5\u652f\u6301 SELECT \u8bed\u53e5");
            }
            Select select = (Select)statement;
            if (select.getWithItemsList() != null) {
                for (WithItem withItem : select.getWithItemsList()) {
                    this.sqlRule.with(withItem.getName().toLowerCase());
                    SelectBody withBody = withItem.getSubSelect().getSelectBody();
                    this.validateSelectBody(withBody, "WITH \u5b50\u53e5 [" + withItem.getName() + "]");
                }
            }
            this.validateSelectBody(select.getSelectBody(), "SELECT");
        }
        catch (JSQLParserException e) {
            throw new IllegalArgumentException("SQL \u89e3\u6790\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    private void validateSelectBody(SelectBody body, String context) {
        if (body instanceof PlainSelect) {
            this.validatePlainSelect((PlainSelect)body, context);
        } else if (body instanceof SetOperationList) {
            for (SelectBody subBody : ((SetOperationList)body).getSelects()) {
                this.validateSelectBody(subBody, "\u5b50\u67e5\u8be2(" + context + ")");
            }
        }
    }

    private void validatePlainSelect(PlainSelect select, String context) {
        Map<String, String> aliasTableMap = this.extractAliasTableMapping(select);
        List<String> fieldAliases = this.extractFiledAliases(select);
        for (SelectItem item : select.getSelectItems()) {
            if (item instanceof AllColumns) {
                throw new IllegalArgumentException("\u7981\u6b62\u4f7f\u7528 SELECT *(\u4f4d\u7f6e\uff1a" + context + ")");
            }
            if (!(item instanceof SelectExpressionItem)) continue;
            SelectExpressionItem selectExpressionItem = (SelectExpressionItem)item;
            this.validateExpression(selectExpressionItem.getExpression(), aliasTableMap, fieldAliases, context + " \u5b57\u6bb5");
        }
        if (select.getWhere() != null) {
            this.validateExpression(select.getWhere(), aliasTableMap, fieldAliases, context + " WHERE");
        }
        if (select.getGroupBy() != null && select.getGroupBy().getGroupByExpressionList().getExpressions() != null) {
            for (OrderByElement expr : select.getGroupBy().getGroupByExpressionList().getExpressions()) {
                this.validateExpression((Expression)expr, aliasTableMap, fieldAliases, context + " GROUP BY");
            }
        }
        if (select.getHaving() != null) {
            this.validateExpression(select.getHaving(), aliasTableMap, fieldAliases, context + " HAVING");
        }
        if (select.getOrderByElements() != null) {
            for (OrderByElement expr : select.getOrderByElements()) {
                this.validateExpression(expr.getExpression(), aliasTableMap, fieldAliases, context + " ORDER BY");
            }
        }
        if (select.getFromItem() instanceof SubSelect) {
            this.validateSelectBody(((SubSelect)select.getFromItem()).getSelectBody(), context + " FROM \u5b50\u67e5\u8be2");
        }
        if (select.getJoins() != null) {
            for (Join join : select.getJoins()) {
                FromItem item = join.getRightItem();
                if (item instanceof SubSelect) {
                    this.validateSelectBody(((SubSelect)item).getSelectBody(), context + " JOIN \u5b50\u67e5\u8be2");
                }
                for (Expression expr : join.getOnExpressions()) {
                    this.validateExpression(expr, aliasTableMap, fieldAliases, context + " JOIN ON");
                }
            }
        }
    }

    private void validateExpression(Expression expr, final Map<String, String> aliasTableMap, final List<String> fieldAliases, final String context) {
        expr.accept((ExpressionVisitor)new ExpressionVisitorAdapter(){

            public void visit(Column column) {
                String actualTable;
                String tableAlias;
                String columnName = column.getColumnName();
                if ("FALSE".equalsIgnoreCase(columnName) || "TRUE".equalsIgnoreCase(columnName) || fieldAliases.contains(columnName)) {
                    return;
                }
                String string = tableAlias = column.getTable() != null ? column.getTable().getName() : null;
                if (tableAlias != null) {
                    actualTable = (String)aliasTableMap.get(tableAlias);
                } else if (aliasTableMap.size() == 1) {
                    actualTable = (String)aliasTableMap.values().iterator().next();
                } else {
                    throw new IllegalArgumentException("\u591a\u8868\u67e5\u8be2\u65f6\uff0c\u5b57\u6bb5 [" + column + "] \u5fc5\u987b\u6307\u5b9a\u8868\u522b\u540d(\u4f4d\u7f6e\uff1a" + context + ")");
                }
                if (SqlSafeValidator.SUBSELECT.equals(aliasTableMap.get(tableAlias)) || SqlSafeValidator.SUBSELECT.equals(actualTable)) {
                    return;
                }
                if (actualTable == null) {
                    throw new IllegalArgumentException("\u5b57\u6bb5 [" + column + "] \u6240\u5c5e\u8868\u672a\u77e5(\u4f4d\u7f6e\uff1a" + context + ")");
                }
                if (SqlSafeValidator.this.sqlRule.containsWith(actualTable)) {
                    return;
                }
                if (!SqlSafeValidator.this.sqlRule.containsTable(actualTable)) {
                    throw new IllegalArgumentException("\u5b57\u6bb5 [" + column + "] \u6240\u5c5e\u8868 [" + actualTable + "] \u4e0d\u5728\u767d\u540d\u5355(\u4f4d\u7f6e\uff1a" + context + ")");
                }
                if (!SqlSafeValidator.this.sqlRule.containsColumn(actualTable, columnName)) {
                    throw new IllegalArgumentException("\u5b57\u6bb5 [" + column + "] \u4e0d\u5728\u8868 [" + actualTable + "] \u7684\u767d\u540d\u5355\u4e2d(\u4f4d\u7f6e\uff1a" + context + ")");
                }
            }

            public void visit(Function function) {
                String funcName = function.getName();
                if (funcName == null) {
                    return;
                }
                if (!SqlSafeValidator.this.sqlRule.containsFunction(funcName)) {
                    throw new IllegalArgumentException("\u51fd\u6570 [" + funcName + "] \u4e0d\u5728\u5168\u5c40\u767d\u540d\u5355\u4e2d(\u4f4d\u7f6e\uff1a" + context + ")");
                }
                if (function.getParameters() != null) {
                    ExpressionList params = function.getParameters();
                    if (params.getExpressions() != null) {
                        for (Expression param : params.getExpressions()) {
                            SqlSafeValidator.this.validateExpression(param, aliasTableMap, fieldAliases, context + " \u51fd\u6570\u53c2\u6570");
                        }
                    }
                } else if (function.isAllColumns() && !"COUNT".equalsIgnoreCase(funcName)) {
                    throw new IllegalArgumentException("\u51fd\u6570 [" + funcName + "] \u4e0d\u5141\u8bb8\u4f7f\u7528 * \u53c2\u6570(\u4f4d\u7f6e\uff1a" + context + ")");
                }
            }

            public void visit(SubSelect subSelect) {
                SqlSafeValidator.this.validateSelectBody(subSelect.getSelectBody(), context + " \u5b50\u67e5\u8be2");
            }
        });
    }

    private List<String> extractFiledAliases(PlainSelect select) {
        ArrayList<String> aliases = new ArrayList<String>();
        for (SelectItem item : select.getSelectItems()) {
            SelectExpressionItem sei;
            Alias alias;
            if (!(item instanceof SelectExpressionItem) || (alias = (sei = (SelectExpressionItem)item).getAlias()) == null) continue;
            aliases.add(alias.getName().replaceAll("'", ""));
        }
        return aliases;
    }

    private Map<String, String> extractAliasTableMapping(PlainSelect select) {
        HashMap<String, String> aliasMap = new HashMap<String, String>();
        this.processFromItem(select.getFromItem(), aliasMap);
        if (select.getJoins() != null) {
            for (Join join : select.getJoins()) {
                this.processFromItem(join.getRightItem(), aliasMap);
            }
        }
        return aliasMap;
    }

    private void processFromItem(FromItem item, Map<String, String> aliasMap) {
        if (item instanceof Table) {
            Table table = (Table)item;
            String normalizedName = this.normalizeTableName(table.getName());
            String alias = table.getAlias() != null ? table.getAlias().getName() : normalizedName;
            aliasMap.put(alias, normalizedName);
        } else if (item instanceof SubSelect) {
            String alias;
            SubSelect subSelect = (SubSelect)item;
            String string = alias = subSelect.getAlias() != null ? subSelect.getAlias().getName() : null;
            if (alias != null) {
                aliasMap.put(alias, SUBSELECT);
            }
        }
    }

    private String normalizeTableName(String name) {
        return name != null ? name.replaceAll("`", "") : null;
    }
}

