/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.console.serice;

import java.util.Collections;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubSelect;

public class CountSqlBuilder {
    public static String buildCountSql(String sql) {
        try {
            Statement statement = CCJSqlParserUtil.parse((String)sql);
            if (!(statement instanceof Select)) {
                throw new IllegalArgumentException("\u4ec5\u652f\u6301 SELECT \u8bed\u53e5");
            }
            Select select = (Select)statement;
            SelectBody body = select.getSelectBody();
            boolean hasPaging = CountSqlBuilder.hasPaging(body);
            if (!hasPaging) {
                return null;
            }
            CountSqlBuilder.removePagingAndOrdering(body);
            if (body instanceof SetOperationList) {
                return CountSqlBuilder.wrapCountSubSelect(body);
            }
            if (body instanceof PlainSelect) {
                PlainSelect ps = (PlainSelect)body;
                if (ps.getGroupBy() != null) {
                    return CountSqlBuilder.wrapCountSubSelect((SelectBody)ps);
                }
                return CountSqlBuilder.buildSimpleCountSelect(ps);
            }
            return null;
        }
        catch (JSQLParserException e) {
            throw new IllegalArgumentException("SQL \u89e3\u6790\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    private static boolean hasPaging(SelectBody body) {
        if (body instanceof PlainSelect) {
            PlainSelect ps = (PlainSelect)body;
            return ps.getLimit() != null || ps.getOffset() != null || ps.getFetch() != null;
        }
        if (body instanceof SetOperationList) {
            SetOperationList set = (SetOperationList)body;
            return set.getLimit() != null || set.getOffset() != null || set.getFetch() != null;
        }
        return false;
    }

    private static void removePagingAndOrdering(SelectBody body) {
        if (body instanceof PlainSelect) {
            PlainSelect ps = (PlainSelect)body;
            ps.setLimit(null);
            ps.setOffset(null);
            ps.setFetch(null);
            ps.setOrderByElements(null);
        } else if (body instanceof SetOperationList) {
            SetOperationList set = (SetOperationList)body;
            set.setLimit(null);
            set.setOffset(null);
            set.setFetch(null);
            set.setOrderByElements(null);
        }
    }

    private static String wrapCountSubSelect(SelectBody body) {
        SubSelect subSelect = new SubSelect();
        subSelect.setSelectBody(body);
        subSelect.setAlias(new Alias("tmp_count"));
        PlainSelect countSelect = new PlainSelect();
        countSelect.setFromItem((FromItem)subSelect);
        countSelect.setSelectItems(Collections.singletonList(new SelectExpressionItem((Expression)new Column("COUNT(*)"))));
        return new Select().withSelectBody((SelectBody)countSelect).toString();
    }

    private static String buildSimpleCountSelect(PlainSelect ps) {
        Function countFunction = new Function();
        countFunction.setName("COUNT");
        ExpressionList list = new ExpressionList();
        list.setExpressions(Collections.singletonList(new AllColumns()));
        countFunction.setParameters(list);
        SelectExpressionItem countItem = new SelectExpressionItem((Expression)countFunction);
        PlainSelect countSelect = new PlainSelect();
        countSelect.setSelectItems(Collections.singletonList(countItem));
        countSelect.setFromItem(ps.getFromItem());
        countSelect.setJoins(ps.getJoins());
        countSelect.setWhere(ps.getWhere());
        return new Select().withSelectBody((SelectBody)countSelect).toString();
    }
}

