package com.digiwin.dap.middle.console.api;

import com.digiwin.dap.middle.console.config.ConsoleRedis;
import com.digiwin.dap.middle.console.domain.RedisEntity;
import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middle.console.config.ConsoleRedisProperties;
import com.digiwin.dap.middleware.util.SecureUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@RestController
@RequestMapping("/api/console/v2/redis")
public class ConsoleRedisController {

    private static final String PERMISSION_SYS_PREFIX = "iam:permission:sys:";

    @Autowired
    private ConsoleRedisProperties redisProperties;
    @Autowired
    private RedisTemplate<String, Object> dapRedisTemplate;

    @PostMapping("/execute")
    public ResponseEntity<?> execute(@RequestBody RedisEntity body) {
        body.setKey(SecureUtils.aesDecrypt(body.getKey()));

        List<RedisEntity> results = new ArrayList<>();
        if ("search".equals(body.getType())) {
            if (body.getKey() == null || body.getKey().replace("*", "").isEmpty()) {
                RedisConnectionFactory connectionFactory = dapRedisTemplate.getConnectionFactory();
                if (!Objects.isNull(connectionFactory)) {
                    Long dbSize = connectionFactory.getConnection().dbSize();
                    results.add(new RedisEntity(body.getKey(), 0L, String.format("当前数据库的key的数量：%s", dbSize)));
                }
            } else {
                results = this.getRedisValues(body.getKey());
            }
        } else if ("total".equals(body.getType())) {
            Set<String> keys = dapRedisTemplate.keys(body.getKey());
            body.setTtl(0L);
            body.setValue(String.format("key的数量：%s", keys == null ? 0 : keys.size()));
            results.add(body);
        } else if ("add".equals(body.getType())) {
            if (body.getTtl() == null || body.getTtl() < 1) {
                dapRedisTemplate.opsForValue().set(body.getKey(), body.getValue());
            } else {
                dapRedisTemplate.opsForValue().set(body.getKey(), body.getValue(), Duration.ofSeconds(body.getTtl()));
            }
            RedisEntity entity = this.getRedisValue(body.getKey());
            results.add(entity);
        } else if ("del".equals(body.getType())) {
            Boolean delete = dapRedisTemplate.delete(body.getKey());
            body.setTtl(0L);
            body.setValue(String.format("成功删除数据：%s条", Boolean.TRUE.equals(delete) ? 1 : 0));
            results.add(body);
        } else if ("ttl".equals(body.getType())) {
            dapRedisTemplate.expire(body.getKey(), body.getTtl(), TimeUnit.SECONDS);
            RedisEntity entity = this.getRedisValue(body.getKey());
            results.add(entity);
        } else if ("get".equals(body.getType())) {
            RedisEntity entity = this.getRedisValue(body.getKey());
            results.add(entity);
        } else if ("keys".equals(body.getType())) {
            Set<String> keys = dapRedisTemplate.keys(body.getKey());
            body.setValue(keys);
            results.add(body);
        }
        return ResponseEntity.ok(results);
    }

    private List<RedisEntity> getRedisValues(String pattern) {
        Set<String> keys = dapRedisTemplate.keys(pattern);
        List<RedisEntity> values = new ArrayList<>();
        if (keys == null || keys.isEmpty()) {
            values.add(new RedisEntity(pattern, 0L, "当前key没用匹配到内容"));
        } else {
            int count = 0;
            for (String key : keys) {
                if (count < 100) {
                    count++;
                    values.add(this.getRedisValue(key));
                } else {
                    values.add(new RedisEntity(key));
                }
            }
        }
        return values;
    }

    private RedisEntity getRedisValue(String key) {
        RedisEntity redisEntity = new RedisEntity();
        redisEntity.setKey(key);
        redisEntity.setTtl(dapRedisTemplate.getExpire(key));

        try {
            if (key.startsWith(PERMISSION_SYS_PREFIX)) {
                Set<Object> objects = RedisUtils.opsForSet().members(key);
                redisEntity.setValue(objects);
            } else {
                Object value = dapRedisTemplate.opsForValue().get(key);
                redisEntity.setValue(value);
            }
        } catch (Exception ignored) {
            try {
                Object value = ConsoleRedis.get(redisProperties).opsForValue().get(key);
                redisEntity.setValue(value);
            } catch (Exception e) {
                redisEntity.setValue("反序列化失败");
            }
        }
        return redisEntity;
    }
}
