package com.digiwin.dap.middle.console.api;

import com.digiwin.dap.middle.console.domain.MariadbEntity;
import com.digiwin.dap.middleware.commons.crypto.AES;
import com.digiwin.dap.middleware.commons.util.StrUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.*;

@RestController
@RequestMapping("/api/console/v2/mariadb")
public class ConsoleMariadbController {

    @Autowired
    private JdbcTemplate jdbcTemplate;

    @PostMapping("/execute")
    public ResponseEntity<?> execute(@RequestBody MariadbEntity body) {
        if (StrUtils.isEmpty(body.getExecute())) {
            return ResponseEntity.ok(Collections.emptyList());
        }
        List<MariadbEntity> results = new ArrayList<>();
        List<String> executes;
        if (body.getSingle()) {
            executes = Collections.singletonList(AES.decrypt(body.getExecute(), KeyConstant.CONSOLE));
        } else {
            executes = Arrays.asList(AES.decrypt(body.getExecute(), KeyConstant.CONSOLE).split(";"));
        }
        for (String execute : executes) {
            long start = System.nanoTime();
            try {
                MariadbEntity mariadbEntity = new MariadbEntity();
                String sql = StringUtils.trimWhitespace(execute);
                Object object;
                String sqlLowerCase = sql.toLowerCase();
                if (sqlLowerCase.contains("insert ") || sqlLowerCase.contains("delete ") || sqlLowerCase.contains("update ")) {
                    object = jdbcTemplate.update(sql);
                } else if (sqlLowerCase.contains("select ") || sqlLowerCase.contains("show ") || sqlLowerCase.contains("desc ") || sqlLowerCase.contains("explain ")) {
                    object = jdbcTemplate.queryForList(sql);
                } else if (sqlLowerCase.contains("call ")) {
                    Map<String, Object> call = jdbcTemplate.call(con -> con.prepareCall(sql), Collections.emptyList());
                    object = call.get("#result-set-1");
                } else if (StrUtils.isEmpty(sql)) {
                    continue;
                } else {
                    jdbcTemplate.execute(sql);
                    object = null;
                }

                mariadbEntity.setSuccess(true);
                mariadbEntity.setSql(sql);
                mariadbEntity.setSecond((System.nanoTime() - start) / 1000000000.0);
                mariadbEntity.setResult(object);
                results.add(mariadbEntity);
            } catch (Exception e) {
                MariadbEntity mariadbEntity = new MariadbEntity();
                mariadbEntity.setSuccess(false);
                mariadbEntity.setSql(execute);
                mariadbEntity.setSecond((System.nanoTime() - start) / 1000000000.0);
                mariadbEntity.setResult(e.getMessage());
                results.add(mariadbEntity);
            }
        }
        return ResponseEntity.ok(results);
    }
}
