package com.digiwin.dap.middleware.converter;

import com.digiwin.dap.middleware.util.SecureUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.annotation.Nullable;
import javax.persistence.AttributeConverter;

/**
 * 字符串转换，方便使用方自定义适配,比如原先是整型类型的手机号，那么就需要手动去转换字符串再设置给实体属性。
 * 或者也可以自己去实现所有的需要使用的字段类型的转换器{@link AttributeConverter}
 * 由于hibernate不支持注解派生，所以只能暴露{@link AttributeConverter}的实现类在外<p>
 * ==============<p>
 * example-entity:
 * <pre>
 * &#064;Column(name = "name", columnDefinition = "VARCHAR(50) NOT NULL COMMENT '名称'")
 * &#064;Convert(converter = StringEnAndDecryptConverter.class)
 * private String name;
 * </pre>
 *
 * @author blockWilling
 * @date 2024/4/11 9:24
 * @mail kangjin@digiwin.com
 */
public class StringEnAndDecryptConverter extends BaseEnAndDecryptConverter<String> {
    private static final Logger logger = LoggerFactory.getLogger(StringEnAndDecryptConverter.class);

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    @Nullable
    public String convertToDatabaseColumn(String attribute) {
        if (attribute == null) {
            return null;
        }
        try {
            return SecureUtils.aesEncrypt(attribute);
        } catch (Exception e) {
            logger.error("【StringEnAndDecryptConverter.convertToDatabaseColumn】{}", e.getMessage());
            return attribute;
        }
    }

    @Override
    @Nullable
    public String convertToEntityAttribute(String dbData) {
        if (dbData == null) {
            return null;
        }
        try {
            return SecureUtils.aesDecrypt(dbData);
        } catch (Exception e) {
            logger.error("【StringEnAndDecryptConverter.convertToEntityAttribute】{}", e.getMessage());
            return dbData;
        }
    }
}
