package com.digiwin.dap.middleware.util;

import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.entity.BaseEntity;

import java.time.LocalDateTime;

/**
 * 获取当前登录用户租户应用信息
 *
 * @author fobgochod
 * @date 2020/6/11
 */
public class TokenUtils {

    @Deprecated
    public static AuthoredUser getAuthoredUser() {
        return UserUtils.getAuthoredUser();
    }

    @Deprecated
    public static AuthoredSys getAuthoredSys() {
        return UserUtils.getAuthoredSys();
    }

    @Deprecated
    public static String getToken() {
        return UserUtils.getToken();
    }

    @Deprecated
    public static long getUserSid() {
        return UserUtils.getUserSid();
    }

    @Deprecated
    public static String getUserId() {
        return UserUtils.getUserId();
    }

    @Deprecated
    public static String getUserName() {
        return UserUtils.getUserName();
    }

    @Deprecated
    public static long getTenantSid() {
        return UserUtils.getTenantSid();
    }

    @Deprecated
    public static String getTenantId() {
        return UserUtils.getTenantId();
    }

    @Deprecated
    public static String getTenantName() {
        return UserUtils.getTenantName();
    }

    @Deprecated
    public static long getSysSid() {
        return UserUtils.getSysSid();
    }

    @Deprecated
    public static String getSysId() {
        return UserUtils.getSysId();
    }

    /**
     * 新增数据，给基础字段赋值
     *
     * @param entity entity
     */
    public static void setCreateFields(BaseEntity entity) {
        //为空则设置创建字段值
        if (entity.getCreateBy() == null || entity.getCreateBy() == 0) {
            entity.setCreateBy(UserUtils.getUserSid());
        }
        if (entity.getCreateById() == null || "".equals(entity.getCreateById())) {
            entity.setCreateById(UserUtils.getUserName());
        }
        entity.setCreateDate(LocalDateTime.now());
        entity.setCreateProvider(UserUtils.getSysSid());
        entity.setCreateOrg(0L);
        //设置修改字段值
        entity.setModifyBy(UserUtils.getUserSid());
        entity.setModifyById(UserUtils.getUserName());
        entity.setModifyDate(LocalDateTime.now());
        entity.setModifyProvider(UserUtils.getSysSid());
    }

    /**
     * 修改数据，给基础字段赋值
     *
     * @param entity entity
     */
    public static void setModifyFields(BaseEntity entity) {
        //设置修改字段值
        entity.setModifyBy(UserUtils.getUserSid());
        entity.setModifyById(UserUtils.getUserName());
        entity.setModifyDate(LocalDateTime.now());
        entity.setModifyProvider(UserUtils.getSysSid());
    }
}
