/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.exception;

import cn.hutool.core.util.IdUtil;
import com.digiwin.dap.middleware.domain.CommonErrorCode;
import com.digiwin.dap.middleware.domain.DapEnv;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.ErrorType;
import com.digiwin.dap.middleware.exception.DapExceptionOrderEnum;
import com.digiwin.dap.middleware.exception.DapLog;
import com.digiwin.dap.middleware.exception.StdError;
import com.digiwin.dap.middleware.util.I18nUtils;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
@RestControllerAdvice
public class DapDataExceptionHandler
implements Ordered {
    private static final Logger logger = LoggerFactory.getLogger(DapDataExceptionHandler.class);
    @Autowired
    private DapEnv dapEnv;

    @ExceptionHandler(value={DataAccessException.class})
    public StdError dataAccess(HttpServletRequest req, DataAccessException e) {
        String expId = IdUtil.simpleUUID();
        logger.error(DapLog.of((String)e.getMessage(), (String)expId, (HttpServletRequest)req).toString(), (Throwable)e);
        StdError stdError = StdError.of((String)this.dapEnv.getAppName().toUpperCase(), (String)ErrorType.System.name(), (ErrorHandler)CommonErrorCode.DATA_ACCESS, (String)req.getRequestURI());
        stdError.setCode(Integer.valueOf(HttpStatus.INTERNAL_SERVER_ERROR.value()));
        stdError.setMessage(I18nUtils.getMessage((String)CommonErrorCode.DATA_ACCESS.getCode()));
        stdError.setExpId(expId);
        if ("dev".equals(this.dapEnv.getActive())) {
            stdError.setDebugInfo(StdError.getDebugInfo((HttpServletRequest)req, (Exception)e));
        }
        return stdError;
    }

    public int getOrder() {
        return DapExceptionOrderEnum.EXCEPTION_DATA.order();
    }
}

