/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.service.impl;

import com.digiwin.dap.middleware.entity.AssociationEntity;
import com.digiwin.dap.middleware.service.AssociationEntityService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class AssociationEntityServiceImpl
implements AssociationEntityService {
    private Map<String, Set<AssociationEntity>> association = new HashMap<String, Set<AssociationEntity>>();

    @Override
    public Set<AssociationEntity> getAssociationEntities(String masterTable) {
        if (!this.association.containsKey(masterTable)) {
            HashSet associationEntities = new HashSet();
            this.association.put(masterTable, associationEntities);
        }
        return this.association.get(masterTable);
    }

    @Override
    public void addAssociationEntities(String masterTable, String slaveTable, String foreignKey, boolean isCascadeDelete) {
        Assert.hasText((String)masterTable, (String)"masterTable\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)slaveTable, (String)"slaveTable\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)foreignKey, (String)"foreignKey\u4e0d\u80fd\u4e3a\u7a7a");
        Set<AssociationEntity> associationEntities = this.getAssociationEntities(masterTable);
        associationEntities.add(new AssociationEntity(slaveTable, foreignKey, isCascadeDelete));
    }
}

