package com.digiwin.dap.middleware.exception;

import cn.hutool.core.util.IdUtil;
import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.domain.CommonErrorCode;
import com.digiwin.dap.middleware.domain.DapEnv;
import com.digiwin.dap.middleware.domain.ErrorType;
import com.digiwin.dap.middleware.util.I18nUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

import javax.servlet.http.HttpServletRequest;

/**
 * 全局异常捕获
 *
 * @author fobgochod
 * @date 2020/6/7
 */
@ResponseStatus(HttpStatus.INTERNAL_SERVER_ERROR)
@RestControllerAdvice
public class DapDataExceptionHandler implements Ordered {

    private static final Logger logger = LoggerFactory.getLogger(DapDataExceptionHandler.class);

    @Autowired
    private DapEnv dapEnv;

    @ExceptionHandler(DataAccessException.class)
    public StdError dataAccess(HttpServletRequest req, DataAccessException e) {
        String expId = IdUtil.simpleUUID();
        logger.error(DapLog.of(e.getMessage(), expId, req).toString(), e);

        StdError stdError = StdError.of(dapEnv.getAppName().toUpperCase(), ErrorType.System.name(), CommonErrorCode.DATA_ACCESS, req.getRequestURI());
        stdError.setCode(HttpStatus.INTERNAL_SERVER_ERROR.value());
        stdError.setMessage(I18nUtils.getMessage(CommonErrorCode.DATA_ACCESS.getCode()));
        stdError.setExpId(expId);
        if (GlobalConstants.ENV_DEV.equals(dapEnv.getActive())) {
            stdError.setDebugInfo(StdError.getDebugInfo(req, e));
        }
        return stdError;
    }

    @Override
    public int getOrder() {
        return DapExceptionOrderEnum.EXCEPTION_DATA.order();
    }
}
