package com.digiwin.dap.middleware.service;

import com.digiwin.dap.middleware.entity.BaseEntity;

import java.util.List;

/**
 * 表操作服务基类，提供基于sid的基本操作
 */
public interface EntityManagerService<T extends BaseEntity> {

    /**
     * 校验实体
     *
     * @param entity 实体对象
     */
    void validate(T entity);

    /**
     * 创建实体
     *
     * @param entity 实体对象
     * @return 实体Sid
     */
    long create(T entity);

    /**
     * 根据sid删除实体
     *
     * @param sid 实体Sid
     */
    void deleteById(long sid);

    /**
     * 报错实体
     *
     * @param entity 实体对象
     */
    void update(T entity);

    /**
     * 修改实体
     *
     * @param entity 实体对象
     * @param force  强制更新
     */
    void update(T entity, boolean force);

    /**
     * 根据Sid 查询实体
     *
     * @param sid 实体Sid
     * @return 实体对象
     */
    T findBySid(long sid);

    /**
     * 根据Sid 判断是否存在
     *
     * @param sid 实体Sid
     */
    boolean exists(long sid);

    /**
     * 根据Sid 禁用实体
     *
     * @param sid 实体Sid
     */
    void disable(long sid);

    /**
     * 根据Sid 启用实体
     *
     * @param sid 实体Sid
     */
    void enable(long sid);

    /**
     * 批量新增实体
     *
     * @param entities 实体对象集合
     */
    void insertAll(Iterable<T> entities);

    /**
     * 批量更新实体
     *
     * @param entities 实体对象集合
     */
    void updateAll(Iterable<T> entities);

    /**
     * 批量保存实体
     *
     * @param entities 实体对象集合
     */
    void saveAll(Iterable<T> entities);

    /**
     * 查询所有
     */
    List<T> findAll();
}
