package com.digiwin.dap.middleware.converter;

import com.digiwin.dap.middleware.util.SecureUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.annotation.Nullable;

/**
 * 整型转换
 *
 * @author blockWilling
 * @date 2024/4/11 9:24
 * @mail kangjin@digiwin.com
 */
public class IntegerEnAndDecryptConverter extends BaseEnAndDecryptConverter<Integer> {
    private static final Logger logger = LoggerFactory.getLogger(IntegerEnAndDecryptConverter.class);

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    @Nullable
    public String convertToDatabaseColumn(Integer attribute) {
        if (attribute == null) {
            return null;
        }
        try {
            return SecureUtils.aesEncrypt(String.valueOf(attribute));
        } catch (Exception e) {
            logger.error("【IntegerEnAndDecryptConverter.convertToDatabaseColumn】{}", e.getMessage());
            return String.valueOf(attribute);
        }
    }

    @Override
    @Nullable
    public Integer convertToEntityAttribute(String dbData) {
        String decrypt = null;
        try {
            decrypt = SecureUtils.aesDecrypt(dbData);
        } catch (Exception e) {
            logger.error("【IntegerEnAndDecryptConverter.convertToEntityAttribute】{}", e.getMessage());
            decrypt = dbData;
        }
        try {
            return Integer.valueOf(decrypt);
        } catch (Exception e) {
            logger.error("【IntegerEnAndDecryptConverter.convertToEntityAttribute】{}", e.getMessage());
            return null;
        }
    }
}
