package com.digiwin.dap.middleware.entity;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;

/**
 * 所有带tenantSid字段
 *
 * @author fobgochod
 * @date 2020/4/27
 */
@MappedSuperclass
public abstract class BaseEntityWithTenant extends BaseEntity {

    /**
     * 租户sid
     */
    @Column(name = "TENANT_SID", nullable = false)
    private long tenantSid;

    public long getTenantSid() {
        return tenantSid;
    }

    public void setTenantSid(long tenantSid) {
        this.tenantSid = tenantSid;
    }
}
