package com.digiwin.dap.middleware.service;

import com.digiwin.dap.middleware.entity.BaseEntityWithPartition;
import org.springframework.data.repository.query.Param;

import java.util.List;

/**
 * 表分区基类
 *
 * @author fobgochod
 * @date 2022/12/2 10:27
 */
public interface EntityWithPartitionManagerService<T extends BaseEntityWithPartition> extends EntityManagerService<T> {

    /**
     * 根据TenantSid获取实体集合
     *
     * @param tenantSid 租户Sid
     * @return 实体对象集合
     */
    List<T> findByTenantSid(@Param("tenantSid") long tenantSid);

    /**
     * 根据实体Id 和租户Id 删除实体
     *
     * @param sid       实体sId
     * @param tenantSid 租户Sid
     */
    void deleteBySidAndTenantSid(long sid, long tenantSid);

    /**
     * 根据tenantSid,id获取sid
     *
     * @param sid       实体Sid
     * @param tenantSid 租户Sid
     * @return sid
     */
    long getSidBySidAndTenantSid(long sid, long tenantSid);

    /**
     * 根据实体Id 和租户Id 查询实体
     *
     * @param sid       实体Sid
     * @param tenantSid 租户Sid
     * @return 实体对象
     */
    T findBySidAndTenantSid(long sid, long tenantSid);

    /**
     * 根据租户sid和id判断是否存在
     *
     * @param sid       实体Sid
     * @param tenantSid 租户Sid
     * @return 是否存在
     */
    boolean existsBySidAndTenantSid(long sid, long tenantSid);

    /**
     * 启用
     *
     * @param sid       实体Sid
     * @param tenantSid 租户Sid
     */
    void enable(long sid, long tenantSid);

    /**
     * 禁用
     *
     * @param sid       实体Sid
     * @param tenantSid 租户Sid
     */
    void disable(long sid, long tenantSid);
}
