/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.service.impl;

import com.digiwin.dap.middleware.domain.CommonErrorCode;
import com.digiwin.dap.middleware.domain.DapEnv;
import com.digiwin.dap.middleware.domain.DeployAreaEnum;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.entity.BaseEntityWithPartition;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.repository.BaseEntityWithPartitionRepository;
import com.digiwin.dap.middleware.service.EntityWithPartitionManagerService;
import com.digiwin.dap.middleware.service.impl.BaseEntityManagerService;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseEntityWithPartitionManagerService<T extends BaseEntityWithPartition>
extends BaseEntityManagerService<T>
implements EntityWithPartitionManagerService<T> {
    private static final Logger logger = LoggerFactory.getLogger(BaseEntityWithPartitionManagerService.class);
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private DapEnv dapEnv;

    @Override
    protected abstract BaseEntityWithPartitionRepository getRepository();

    public void checkPartition(long tenantSid) {
        if (tenantSid > 0L) {
            return;
        }
        if (DeployAreaEnum.isDev((String)this.dapEnv.getDeployArea())) {
            logger.error(CommonErrorCode.PARTITION_CHECK.getErrorMessage(new Object[]{this.getMappingTableName()}));
        } else if (DeployAreaEnum.isTest((String)this.dapEnv.getDeployArea())) {
            logger.warn(CommonErrorCode.PARTITION_CHECK.getErrorMessage(new Object[]{this.getMappingTableName()}));
        }
    }

    @Override
    public long create(T entity) {
        this.checkPartition(((BaseEntityWithPartition)entity).getTenantSid());
        return super.create(entity);
    }

    @Override
    public void deleteById(long sid) {
        this.checkPartition(0L);
        super.deleteById(sid);
    }

    @Override
    public void update(T entity) {
        this.checkPartition(((BaseEntityWithPartition)entity).getTenantSid());
        super.update(entity);
    }

    @Override
    public void update(T entity, boolean force) {
        this.checkPartition(((BaseEntityWithPartition)entity).getTenantSid());
        super.update(entity, force);
    }

    @Override
    public T findBySid(long sid) {
        this.checkPartition(0L);
        return (T)((BaseEntityWithPartition)super.findBySid(sid));
    }

    @Override
    public boolean exists(long sid) {
        this.checkPartition(0L);
        return super.exists(sid);
    }

    @Override
    public void disable(long sid) {
        this.checkPartition(0L);
        super.disable(sid);
    }

    @Override
    public void enable(long sid) {
        this.checkPartition(0L);
        super.enable(sid);
    }

    @Override
    public void insertAll(Iterable<T> entities) {
        for (BaseEntityWithPartition entity : entities) {
            this.checkPartition(entity.getTenantSid());
        }
        super.insertAll(entities);
    }

    @Override
    public void updateAll(Iterable<T> entities) {
        for (BaseEntityWithPartition entity : entities) {
            this.checkPartition(entity.getTenantSid());
        }
        super.updateAll(entities);
    }

    @Override
    public void saveAll(Iterable<T> entities) {
        for (BaseEntityWithPartition entity : entities) {
            this.checkPartition(entity.getTenantSid());
        }
        super.saveAll(entities);
    }

    @Override
    public List<T> findAll() {
        if (DeployAreaEnum.isTest((String)this.dapEnv.getDeployArea())) {
            logger.warn("\u8be5\u8868[{}]\u662f\u5206\u533a\u8868\uff0c\u6b63\u5728\u8fdb\u884c\u5168\u533a\u67e5\u8be2\uff0c\u8bf7\u6ce8\u610f\u3002", (Object)this.getMappingTableName());
        }
        return super.findAll();
    }

    @Override
    public List<T> findByTenantSid(long tenantSid) {
        return this.getRepository().findByTenantSid(tenantSid);
    }

    @Override
    public void deleteBySidAndTenantSid(long sid, long tenantSid) {
        this.getRepository().deleteBySidAndTenantSid(sid, tenantSid);
    }

    @Override
    public long getSidBySidAndTenantSid(long sid, long tenantSid) {
        Object entity = this.getRepository().findBySidAndTenantSid(sid, tenantSid);
        if (entity == null) {
            return 0L;
        }
        return ((BaseEntity)entity).getSid();
    }

    @Override
    public T findBySidAndTenantSid(long sid, long tenantSid) {
        return this.getRepository().findBySidAndTenantSid(sid, tenantSid);
    }

    @Override
    public boolean existsBySidAndTenantSid(long sid, long tenantSid) {
        return this.getRepository().existsBySidAndTenantSid(sid, tenantSid);
    }

    @Override
    public void enable(long sid, long tenantSid) {
        Object result = this.getRepository().findBySidAndTenantSid(sid, tenantSid);
        if (result == null) {
            throw new BusinessException("\u6570\u636e\u5df2\u7ecf\u88ab\u5220\u9664.sid:" + sid + ",tenantSid:" + tenantSid);
        }
        ((BaseEntity)result).setDisabled(false);
        this.getRepository().save(result);
    }

    @Override
    public void disable(long sid, long tenantSid) {
        Object result = this.getRepository().findBySidAndTenantSid(sid, tenantSid);
        if (result == null) {
            throw new BusinessException("\u6570\u636e\u5df2\u7ecf\u88ab\u5220\u9664.sid:" + sid + ",tenantSid:" + tenantSid);
        }
        ((BaseEntity)result).setDisabled(true);
        this.getRepository().save(result);
    }
}

