package com.digiwin.dap.middleware.service;

import com.digiwin.dap.middleware.entity.AssociationEntity;

import java.util.Set;

public interface AssociationEntityService {
    /**
     * 添加实体之间的关联
     *
     * @param masterTable     主表
     * @param slaveTable      从表
     * @param foreignKey      关联字段
     * @param isCascadeDelete 是否级联删除，如果true，删除主表的时候，自动删除关联的数据，否则删除会做引用检查，一旦存在引用，禁止删除
     */
    void addAssociationEntities(String masterTable, String slaveTable, String foreignKey, boolean isCascadeDelete);

    /**
     * 获取被依赖的表
     *
     * @param masterTable 实体名
     * @return
     */
    Set<AssociationEntity> getAssociationEntities(String masterTable);
}
