package com.digiwin.dap.middleware.repository;

import com.digiwin.dap.middleware.entity.BaseEntityWithIdAndTenant;
import org.springframework.data.repository.NoRepositoryBean;
import org.springframework.data.repository.query.Param;

import java.util.List;

/**
 * Id和租户sid作为不可重复key的实体的基本DAO，提供基于id和租户sid的基本操作
 */
@NoRepositoryBean
public interface BaseEntityWithTenantRepository<T extends BaseEntityWithIdAndTenant, ID> extends BaseEntityRepository<T, ID> {

    /**
     * 根据TenantSid获取实体集合
     *
     * @param tenantSid 租户Sid
     * @return
     */
    List<T> findByTenantSid(@Param("tenantSid") long tenantSid);

    /**
     * 根据Id和TenantSid获取实体
     *
     * @param tenantSid 租户Sid
     * @param id        实体ID
     * @return 实体对象
     */
    T findByTenantSidAndId(@Param("tenantSid") long tenantSid, @Param("id") String id);

    /**
     * 根据租户sid和id判断是否存在
     *
     * @param tenantSid
     * @param id
     * @return
     */
    boolean existsByTenantSidAndId(@Param("tenantSid") long tenantSid, @Param("id") String id);

    /**
     * 根据Id和TenantSid删除实体
     *
     * @param tenantSid 租户Sid
     * @param id        实体ID
     * @return 实体对象
     */
    void deleteByTenantSidAndId(@Param("tenantSid") long tenantSid, @Param("id") String id);
}
