package com.digiwin.dap.middleware.repository;

import com.digiwin.dap.middleware.entity.BaseEntityWithPartition;
import org.springframework.data.repository.NoRepositoryBean;
import org.springframework.data.repository.query.Param;

import java.util.List;

@NoRepositoryBean
public interface BaseEntityWithPartitionRepository<T extends BaseEntityWithPartition, ID> extends BaseEntityRepository<T, ID> {

    /**
     * 根据TenantSid获取实体集合
     *
     * @param tenantSid 租户Sid
     * @return 实体对象集合
     */
    List<T> findByTenantSid(@Param("tenantSid") long tenantSid);

    /**
     * 根据sid和TenantSid删除实体
     *
     * @param sid       实体Sid
     * @param tenantSid 租户Sid
     */
    void deleteBySidAndTenantSid(@Param("sid") long sid, @Param("tenantSid") long tenantSid);

    /**
     * 根据Id和TenantSid获取实体
     *
     * @param sid       实体Sid
     * @param tenantSid 租户Sid
     * @return 实体对象
     */
    T findBySidAndTenantSid(@Param("sid") long sid, @Param("tenantSid") long tenantSid);

    /**
     * 根据租户sid和id判断是否存在
     *
     * @param sid       实体Sid
     * @param tenantSid 租户Sid
     * @return 实体对象
     */
    boolean existsBySidAndTenantSid(@Param("sid") long sid, @Param("tenantSid") long tenantSid);
}
