/*
 * Copyright (c) 2019.  鼎捷软件股份有限公司.All rights reserved.
 */

package com.digiwin.dap.middleware.service;

import com.digiwin.dap.middleware.entity.BaseEntityWithIdAndTenant;

/**
 * 基于sid和id组成的不可重复索引的表操作
 */
public interface EntityWithTenantManagerService<T extends BaseEntityWithIdAndTenant> extends EntityManagerService<T> {


    /**
     * 根据tenantSid,id获取sid
     *
     * @param tenantSid  租户sid
     * @param id id
     * @return sid
     */
    long getSidByTenantAndId(long tenantSid, String id);

    /**
     * 根据实体Id 和租户Id 查询实体
     *
     * @param tenantSid 租户Sid
     * @param id        实体Id
     * @return 实体对象
     */
    T findByTenantSidAndId(long tenantSid, String id);

    /**
     * 根据实体Id 和租户Id 删除实体
     *
     * @param tenantSid 租户Sid
     * @param id        实体Id
     */

    void deleteByTenantSidAndId(long tenantSid, String id);

    /**
     * 根据租户sid和id判断是否存在
     *
     * @param tenantSid
     * @param id
     * @return
     */
    boolean existsByTenantSidAndId(long tenantSid, String id);

    /**
     * 启用
     *
     * @param tenantSid 租户sid
     * @param id        实体id
     * @return
     */
    void enable(long tenantSid, String id);

    /**
     * 禁用
     *
     * @param tenantSid 租户sid
     * @param id        实体id
     * @return
     */
    void disable(long tenantSid, String id);
}
