package com.digiwin.dap.middleware.repository;

import com.digiwin.dap.middleware.entity.BaseEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.repository.NoRepositoryBean;


/**
 * 基本的dao，封装基于BaseEntity的操作
 *
 * @author chenxsa
 */
@NoRepositoryBean
public interface BaseEntityRepository<T extends BaseEntity, ID> extends JpaRepository<T, ID>, JpaSpecificationExecutor<T> {

    /**
     * 批量插入
     *
     * @param entities
     * @param <S>
     * @return
     */
    <S extends T> void insert(Iterable<S> entities);

    /**
     * 批量修改
     *
     * @param entities
     * @param <S>
     * @return
     */
    <S extends T> void update(Iterable<S> entities);
}
