/*
 * Copyright (c) 2019.  鼎捷软件股份有限公司.All rights reserved.
 */

package com.digiwin.dap.middleware.service;

import com.digiwin.dap.middleware.entity.BaseEntityWithId;

/**
 * 表操作服务基类，提供基于id作为唯一索引的基本操作
 */
public interface EntityWithIdManagerService<T extends BaseEntityWithId> extends EntityManagerService<T> {

    /**
     * 根据id获取sid
     *
     * @param id 实体Id
     */
    long getSidById(String id);

    /**
     * 根据实体Id 查询实体
     *
     * @param id 实体Id
     * @return 实体对象
     */
    T findById(String id);

    /**
     * 根据实体Id 删除实体
     *
     * @param id 实体Id
     */

    void deleteById(String id);

    /**
     * 根据id判断是否存在
     *
     * @param id
     * @return
     */
    boolean existsById(String id);

    /**
     * 根据用户Id 启用
     *
     * @param id Id
     */
    void enable(String id);


    /**
     * 根据用户Id 禁用
     *
     * @param id Id
     */
    void disable(String id);
}
