/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.entity;

import com.digiwin.dap.middleware.commons.util.BeanUtils;
import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import jakarta.persistence.Column;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.validation.constraints.NotNull;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.Assert;

public class UnionKey {
    private static final Pattern regex = Pattern.compile("[A-Z]+");
    private final List<String> fields = new ArrayList<String>();
    private final List<String> tableFields = new ArrayList<String>();
    private Class<?> entityClass;

    public static UnionKey create() {
        return new UnionKey();
    }

    public List<String> getFields() {
        return this.fields;
    }

    public UnionKey apply(@NotNull Class<?> entityClass) {
        Assert.notNull(entityClass, (String)"entityClass \u4e0d\u80fd\u4e3anull");
        this.entityClass = entityClass;
        return this;
    }

    public UnionKey add(@NotNull String name) {
        if (StrUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("name \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.fields.contains(name)) {
            throw new IllegalArgumentException("\u5b58\u5728\u91cd\u590d\u7684\u503c\uff1a" + name);
        }
        Assert.notNull(this.entityClass, (String)"entityClass \u4e0d\u80fd\u4e3anull,\u8bf7\u5148\u8c03\u7528apply\u65b9\u6cd5");
        Field field = BeanUtils.getDeclaredField(this.entityClass, (String)name);
        if (field == null) {
            throw new BusinessException(String.format("%s \u4e0a\u4e0d\u5b58\u5728\u5c5e\u6027%s", this.entityClass, name));
        }
        this.fields.add(name);
        String columnName = name;
        Column column = field.getAnnotation(Column.class);
        if (column != null && StrUtils.isNotEmpty((String)column.name())) {
            columnName = column.name().toUpperCase();
            columnName = columnName.replace("[", "`");
            columnName = columnName.replace("]", "`");
            this.tableFields.add(columnName);
        } else {
            Matcher matcher = regex.matcher(columnName);
            if (matcher.find()) {
                columnName = matcher.replaceAll("_$0");
            }
            columnName = columnName.toUpperCase();
            this.tableFields.add(columnName);
        }
        return this;
    }

    public void clear() {
        this.fields.clear();
        this.tableFields.clear();
    }

    public String getSelectSql() {
        StringBuilder sql = new StringBuilder();
        for (int i = 0; i < this.tableFields.size(); ++i) {
            sql.append(this.tableFields.get(i));
            if (i >= this.tableFields.size() - 1) continue;
            sql.append(",");
        }
        return sql.toString();
    }

    public String getWhere(Object ... values) {
        if (values == null || values.length != this.fields.size()) {
            throw new IllegalArgumentException("\u503c\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\u53ef\u80fd\u5c0f\u4e8e\u6216\u8005\u5927\u4e8e\u552f\u4e00\u952e\u7684\u6570\u91cf");
        }
        StringBuilder sql = new StringBuilder();
        for (int i = 0; i < this.tableFields.size(); ++i) {
            sql.append(String.format("%s = :%s", this.tableFields.get(i), this.fields.get(i)));
            if (i >= this.fields.size() - 1) continue;
            sql.append(" AND ");
        }
        return sql.toString();
    }

    public String getWhereSql(Object ... values) {
        if (values == null || values.length != this.fields.size()) {
            throw new IllegalArgumentException("\u503c\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\u53ef\u80fd\u5c0f\u4e8e\u6216\u8005\u5927\u4e8e\u4e3b\u952e\u7684\u6570\u91cf");
        }
        StringBuilder sql = new StringBuilder();
        for (int i = 0; i < this.tableFields.size(); ++i) {
            Object paraValue = values[i];
            String paraName = this.tableFields.get(i);
            if (paraValue == null) {
                sql.append(String.format("ISNULL(%s)", paraName));
            } else if (paraValue instanceof Integer || paraValue instanceof Long || paraValue instanceof Double || paraValue instanceof Boolean) {
                sql.append(String.format("%s = %s", paraName, paraValue));
            } else {
                sql.append(String.format("%s = '%s'", paraName, paraValue));
            }
            if (i >= this.fields.size() - 1) continue;
            sql.append(" AND ");
        }
        return sql.toString();
    }

    public <T extends BaseEntity> Predicate getSpecification(Root<T> root, CriteriaQuery<?> cq, CriteriaBuilder cb, Object ... values) {
        if (values == null || values.length != this.fields.size()) {
            throw new IllegalArgumentException("\u503c\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\u53ef\u80fd\u5c0f\u4e8e\u4e3b\u952e\u7684\u6570\u91cf");
        }
        Predicate predicate = cb.conjunction();
        for (int i = 0; i < this.fields.size(); ++i) {
            Object paraValue = values[i];
            String paraName = this.fields.get(i);
            if (paraValue == null) {
                predicate.getExpressions().add(cb.isNull((Expression)root.get(paraName)));
                continue;
            }
            if (paraValue instanceof Integer || paraValue instanceof Long || paraValue instanceof Double || paraValue instanceof Boolean) {
                predicate.getExpressions().add(cb.equal(root.get(paraName).as(Long.TYPE), paraValue));
                continue;
            }
            predicate.getExpressions().add(cb.equal(root.get(paraName).as(String.class), paraValue));
        }
        return predicate;
    }
}

