/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.repository.impl;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.repository.BaseEntityRepository;
import com.digiwin.dap.middleware.util.SnowFlake;
import jakarta.persistence.EntityManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.JpaEntityInformationSupport;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Transactional(readOnly=true)
public class BaseEntityRepositoryImpl<T extends BaseEntity, ID>
extends SimpleJpaRepository<T, ID>
implements BaseEntityRepository<T, ID> {
    private final JpaEntityInformation<T, ?> entityInformation;
    private final EntityManager em;

    public BaseEntityRepositoryImpl(JpaEntityInformation<T, ?> entityInformation, EntityManager entityManager) {
        super(entityInformation, entityManager);
        this.entityInformation = entityInformation;
        this.em = entityManager;
    }

    public BaseEntityRepositoryImpl(Class<T> domainClass, EntityManager em) {
        this(JpaEntityInformationSupport.getEntityInformation(domainClass, (EntityManager)em), em);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public <S extends T> void insert(Iterable<S> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities not be null!");
        Iterator<S> var3 = entities.iterator();
        int index = 0;
        while (var3.hasNext()) {
            BaseEntity entity = (BaseEntity)var3.next();
            if (entity.getSid() == 0L) {
                entity.setSid(SnowFlake.getInstance().newId());
            }
            this.em.persist((Object)entity);
            if (++index % 500 != 0) continue;
            this.em.flush();
            this.em.clear();
        }
        if (index % 500 != 0) {
            this.em.flush();
            this.em.clear();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public <S extends T> void update(Iterable<S> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities not be null!");
        Iterator<S> var3 = entities.iterator();
        int index = 0;
        while (var3.hasNext()) {
            BaseEntity entity = (BaseEntity)var3.next();
            this.em.merge((Object)entity);
            if (++index % 500 != 0) continue;
            this.em.flush();
            this.em.clear();
        }
        if (index % 500 != 0) {
            this.em.flush();
            this.em.clear();
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public <S extends T> List<S> saveAll(Iterable<S> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities not be null!");
        ArrayList<BaseEntity> result = new ArrayList<BaseEntity>();
        Iterator<S> var3 = entities.iterator();
        int index = 0;
        while (var3.hasNext()) {
            BaseEntity entity = (BaseEntity)var3.next();
            if (this.entityInformation.isNew((Object)entity)) {
                entity.setSid(SnowFlake.getInstance().newId());
                this.em.persist((Object)entity);
            } else {
                this.em.merge((Object)entity);
            }
            if (++index % 500 == 0) {
                this.em.flush();
                this.em.clear();
            }
            result.add(entity);
        }
        if (index % 500 != 0) {
            this.em.flush();
            this.em.clear();
        }
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public <S extends T> S save(S entity) {
        if (this.entityInformation.isNew(entity)) {
            ((BaseEntity)entity).setSid(SnowFlake.getInstance().newId());
            this.em.persist(entity);
            return entity;
        }
        return (S)((BaseEntity)this.em.merge(entity));
    }
}

