/*
 * Copyright (c) 2019.  鼎捷软件股份有限公司.All rights reserved.
 */

package com.digiwin.dap.middleware.service;

import java.util.List;

/**
 * 级联删除服务
 */
public interface CascadeDeleteEntityService {

    /**
     * 根据某个字段删除表中数据
     *
     * @param tableName 表名
     * @param sids      字段值列表
     */
    void delete(String tableName, List<Long> sids);

    /**
     * 根據兩個字段刪除關連表中數據
     *
     * @param tableName
     * @param masterSid
     * @param slaveSid
     */
    void deleteRelation(String tableName, Long masterSid, Long slaveSid);
}
