/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.service.impl;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.entity.BaseEntityWithId;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.repository.BaseEntityWithIdRepository;
import com.digiwin.dap.middleware.service.EntityWithIdManagerService;
import com.digiwin.dap.middleware.service.impl.BaseEntityManagerService;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import java.util.List;

public abstract class BaseEntityWithIdManagerService<T extends BaseEntityWithId>
extends BaseEntityManagerService<T>
implements EntityWithIdManagerService<T> {
    @PersistenceContext
    EntityManager entityManager;

    @Override
    protected abstract BaseEntityWithIdRepository getRepository();

    @Override
    public long getSidById(String id) {
        String sql = String.format("SELECT sid FROM %s WHERE id = :id LIMIT 1", this.getMappingTableName());
        Query query = this.entityManager.createNativeQuery(sql);
        query.setParameter("id", (Object)id);
        List resultList = query.getResultList();
        if (resultList.size() == 0) {
            return 0L;
        }
        return Long.parseLong(resultList.get(0).toString());
    }

    @Override
    public T findById(String id) {
        return this.getRepository().findById(id);
    }

    @Override
    public void deleteById(String id) {
        this.getRepository().deleteById(id);
    }

    @Override
    public boolean existsById(String id) {
        return this.getRepository().existsById(id);
    }

    @Override
    public void enable(String id) {
        Object data = this.getRepository().findById(id);
        if (data == null) {
            throw new BusinessException("\u6570\u636e\u5df2\u7ecf\u88ab\u5220\u9664.id:" + id);
        }
        ((BaseEntity)data).setDisabled(false);
        this.getRepository().save(data);
    }

    @Override
    public void disable(String id) {
        Object data = this.getRepository().findById(id);
        if (data == null) {
            throw new BusinessException("\u6570\u636e\u5df2\u7ecf\u88ab\u5220\u9664.id:" + id);
        }
        ((BaseEntity)data).setDisabled(true);
        this.getRepository().save(data);
    }
}

