package com.digiwin.dap.middleware.service;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.entity.UnionKey;

/**
 * 基于UnionKey组成的不可重复索引的表操作
 *
 */
@Deprecated
public interface EntityWithUnionKeyManagerService<T extends BaseEntity> extends EntityManagerService<T> {

    /**
     * 获取表对应的业务主键字段
     *
     * @return
     */
    UnionKey getUnionKey();

    /**
     * 根据unionkey获取sid
     *
     * @param values
     * @return sid
     */
    long getSidByUnionKey(Object... values);

    /**
     * 根据实体Id 和租户Id 查询实体
     *
     * @param values 租户Sid
     * @return 实体对象
     */
    T findByUnionKey(Object... values);

    /**
     * 根据实体Id 和租户Id 删除实体
     *
     * @param values 业务逐渐对应的值
     */

    void deleteByUnionKey(Object... values);

    /**
     * 根据租户sid和id判断是否存在
     *
     * @param values 业务逐渐对应的值
     * @return
     */
    boolean existsByUnionKey(Object... values);

    /**
     * 启用
     *
     * @param values 业务逐渐对应的值
     * @return
     */
    void enable(Object... values);

    /**
     * 禁用
     *
     * @param values 业务逐渐对应的值
     * @return
     */
    void disable(Object... values);
}
