package com.digiwin.dap.middleware.service.impl;

import com.digiwin.dap.middleware.entity.RelationAssociationEntity;
import com.digiwin.dap.middleware.service.RelationAssociationEntityService;

import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class RelationAssociationEntityServiceImpl implements RelationAssociationEntityService {

    private Map<String, List<RelationAssociationEntity>> association = new HashMap<>();

    @Override
    public List<RelationAssociationEntity> getAssociationEntities(String masterTable) {
        if (!association.containsKey(masterTable)) {
            List<RelationAssociationEntity> associationEntities = new ArrayList<>();
            association.put(masterTable, associationEntities);
        }
        return association.get(masterTable);
    }

    @Override
    public void addAssociationEntities(String tableName, String targetTable,
                                       String masterTable, String masterField,
                                       String slaveTable, String slaveField,
                                       String checkFiled, boolean checkSelf) {
        Assert.hasText(tableName, "tableName不能为空");
        Assert.hasText(targetTable, "targetTable不能为空");
        Assert.hasText(masterTable, "masterTable不能为空");
        Assert.hasText(masterField, "masterField不能为空");
        Assert.hasText(slaveTable, "slaveTable不能为空");
        Assert.hasText(slaveField, "slaveField不能为空");
        Assert.hasText(checkFiled, "checkFiled不能为空");

        List<RelationAssociationEntity> associationEntities = getAssociationEntities(tableName);
        associationEntities.add(new RelationAssociationEntity(targetTable, masterTable, masterField,
                slaveTable, slaveField, checkFiled, checkSelf));
    }
}
