/*
 * Copyright (c) 2019.  鼎捷软件股份有限公司.All rights reserved.
 */

package com.digiwin.dap.middleware.service;


import com.digiwin.dap.middleware.entity.RelationAssociationEntity;

import java.util.List;

public interface RelationAssociationEntityService {

    /**
     * 获取被依赖的表
     *
     * @param masterTable 实体名
     * @return
     */
    List<RelationAssociationEntity> getAssociationEntities(String masterTable);

    /**
     * 添加实体之间的关联
     *
     * @param table
     * @param targetTable 主表
     * @param masterTable 關聯表1
     * @param masterField 關聯表1欄位
     * @param slaveTable  關聯表2
     * @param slaveField  關聯表2欄位
     * @param checkField  關聯表2的限制欄位
     * @param checkSelf   關聯表1上是否已有限制欄位
     */
    void addAssociationEntities(String table, String targetTable,
                                String masterTable, String masterField,
                                String slaveTable, String slaveField,
                                String checkField, boolean checkSelf);
}
