/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.service.impl;

import com.digiwin.dap.middleware.commons.util.BeanUtils;
import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.domain.DapEnv;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.repository.BaseEntityRepository;
import com.digiwin.dap.middleware.service.EntityManagerService;
import com.digiwin.dap.middleware.util.EntityUtils;
import jakarta.persistence.Table;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public abstract class BaseEntityManagerService<T extends BaseEntity>
implements EntityManagerService<T> {
    @Autowired
    protected DapEnv dapEnv;
    private String tableName;

    protected String getMappingTableName() {
        if (StrUtils.isNotEmpty((String)this.tableName)) {
            return this.tableName;
        }
        Class clazz = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        Table table = clazz.getAnnotation(Table.class);
        if (table == null || StrUtils.isEmpty((String)table.name())) {
            this.tableName = clazz.getSimpleName();
        } else if (table.name().startsWith("[")) {
            this.tableName = table.name().replace("[", "`");
            this.tableName = this.tableName.replace("]", "`");
        } else {
            this.tableName = table.name();
        }
        return this.tableName;
    }

    protected abstract JpaRepository getRepository();

    @Override
    public void validate(T entity) {
    }

    @Override
    public long create(T entity) {
        EntityUtils.setCreateFields(entity);
        this.getRepository().save(entity);
        this.getRepository().flush();
        return ((BaseEntity)entity).getSid();
    }

    @Override
    public void deleteById(long sid) {
        this.getRepository().deleteById((Object)sid);
    }

    @Override
    public void update(T entity) {
        this.update(entity, false);
    }

    @Override
    public void update(T entity, boolean force) {
        if (((BaseEntity)entity).getSid() == 0L) {
            throw new BusinessException("\u6570\u636esid\u4e3a0\uff0c\u65e0\u6cd5\u8fdb\u884c\u66f4\u65b0\uff0c\u786e\u8ba4\u662f\u5426\u4e3a\u4fdd\u5b58");
        }
        EntityUtils.setModifyFields(entity);
        Optional result = this.getRepository().findById((Object)((BaseEntity)entity).getSid());
        if (!result.isPresent()) {
            throw new BusinessException("\u6570\u636e\u5df2\u7ecf\u88ab\u5220\u9664.sid:" + ((BaseEntity)entity).getSid());
        }
        BaseEntity dbData = (BaseEntity)result.get();
        BeanUtils.mergeObject(entity, (Object)dbData);
        this.getRepository().save((Object)dbData);
        this.getRepository().flush();
    }

    @Override
    public T findBySid(long sid) {
        Optional entity = this.getRepository().findById((Object)sid);
        return (T)((BaseEntity)entity.orElse(null));
    }

    @Override
    public boolean exists(long sid) {
        return this.getRepository().existsById((Object)sid);
    }

    @Override
    public void disable(long sid) {
        T result = this.findBySid(sid);
        if (result == null) {
            throw new BusinessException("\u6570\u636e\u5df2\u7ecf\u88ab\u5220\u9664.sid:" + sid);
        }
        ((BaseEntity)result).setDisabled(true);
        this.update(result);
    }

    @Override
    public void enable(long sid) {
        T result = this.findBySid(sid);
        if (result == null) {
            throw new BusinessException("\u6570\u636e\u5df2\u7ecf\u88ab\u5220\u9664.sid:" + sid);
        }
        ((BaseEntity)result).setDisabled(false);
        this.update(result);
    }

    @Override
    public void insertAll(Iterable<T> entities) {
        if (this.getRepository() instanceof BaseEntityRepository) {
            for (BaseEntity entity : entities) {
                EntityUtils.setCreateFields(entity);
            }
            ((BaseEntityRepository)this.getRepository()).insert(entities);
        } else {
            this.saveAll(entities);
        }
    }

    @Override
    public void updateAll(Iterable<T> entities) {
        if (this.getRepository() instanceof BaseEntityRepository) {
            for (BaseEntity entity : entities) {
                EntityUtils.setModifyFields(entity);
            }
            ((BaseEntityRepository)this.getRepository()).update(entities);
        } else {
            this.saveAll(entities);
        }
    }

    @Override
    public void saveAll(Iterable<T> entities) {
        for (BaseEntity entity : entities) {
            if (entity.getSid() == 0L) {
                EntityUtils.setCreateFields(entity);
                continue;
            }
            EntityUtils.setModifyFields(entity);
        }
        this.getRepository().saveAll(entities);
    }

    @Override
    public List<T> findAll() {
        return this.getRepository().findAll();
    }
}

