/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.support.upgrade;

import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.service.UpdateDatabaseService;
import com.digiwin.dap.middleware.support.upgrade.UpgradeHandler;
import com.digiwin.dap.middleware.support.upgrade.UpgradeVO;
import com.digiwin.dap.middleware.support.upgrade.Version;
import com.digiwin.dap.middleware.support.upgrade.VersionMapper;
import com.digiwin.dap.middleware.util.DateUtils;
import com.digiwin.dap.middleware.util.FileUtil;
import com.digiwin.dap.middleware.util.SnowFlake;
import com.digiwin.dap.middleware.util.UserUtils;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class DefaultUpgradeHandler
implements UpgradeHandler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultUpgradeHandler.class);
    private final JdbcTemplate jdbcTemplate;
    private final List<UpdateDatabaseService> updateDatabaseServices;

    public DefaultUpgradeHandler(JdbcTemplate jdbcTemplate, List<UpdateDatabaseService> updateDatabaseServices) {
        this.jdbcTemplate = jdbcTemplate;
        this.updateDatabaseServices = updateDatabaseServices;
    }

    private void createTableVersion() {
        try {
            boolean exists = this.jdbcTemplate.queryForList("show tables like 'version'").stream().findAny().isPresent();
            if (!exists) {
                String sql = FileUtil.getFile((String)"/support/version.sql");
                this.jdbcTemplate.execute(sql);
            }
        }
        catch (Exception e) {
            logger.error("create table version error", (Throwable)e);
        }
    }

    public List<Object> upgrade(String startVersion, String endVersion) {
        ArrayList<Object> upgrades = new ArrayList<Object>();
        this.createTableVersion();
        int oldVersion = this.jdbcTemplate.queryForList("select version from version order by sid desc limit 1", Integer.class).stream().findFirst().orElse(0) + 1;
        for (UpdateDatabaseService currentService : this.updateDatabaseServices) {
            if (!currentService.support(startVersion, endVersion)) continue;
            long startTime = System.currentTimeMillis();
            currentService.before();
            currentService.update();
            currentService.after();
            long upgradeTime = System.currentTimeMillis() - startTime;
            this.save(oldVersion, currentService.version(), upgradeTime);
            upgrades.add(new UpgradeVO(Long.valueOf(upgradeTime), currentService.version(), currentService.getClass().getName()));
        }
        return upgrades;
    }

    public Version findLatestVersion() {
        List lists = this.jdbcTemplate.query("select sid,success,version,middleware_version,update_by,update_by_id,update_date,execution_time from version where success = 1 order by sid desc limit 1", (RowMapper)new VersionMapper());
        return lists.stream().findFirst().orElse(null);
    }

    private void save(int oldVersion, String middlewareVersion, long executionTime) {
        AuthoredUser authoredUser = UserUtils.getAuthoredUser();
        String insert = authoredUser == null ? String.format("INSERT INTO version(sid,success,version,middleware_version,update_date,execution_time) VALUES (%s, true, %s, '%s', '%s', %s);", SnowFlake.getInstance().newId(), oldVersion, middlewareVersion, DateUtils.formatDateTime((TemporalAccessor)LocalDateTime.now()), executionTime) : String.format("INSERT INTO version(sid,success,version,middleware_version,update_by,update_by_id,update_date,execution_time) VALUES (%s, true, %s, '%s', %s, '%s', '%s', %s);", SnowFlake.getInstance().newId(), oldVersion, middlewareVersion, authoredUser.getSid(), authoredUser.getUserName(), DateUtils.formatDateTime((TemporalAccessor)LocalDateTime.now()), executionTime);
        this.jdbcTemplate.execute(insert);
    }
}

