/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.service.impl;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.entity.BaseEntityWithIdAndTenant;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.repository.BaseEntityWithTenantRepository;
import com.digiwin.dap.middleware.service.EntityWithTenantManagerService;
import com.digiwin.dap.middleware.service.impl.BaseEntityManagerService;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import java.util.List;

public abstract class BaseEntityWithTenantManagerService<T extends BaseEntityWithIdAndTenant>
extends BaseEntityManagerService<T>
implements EntityWithTenantManagerService<T> {
    @PersistenceContext
    EntityManager entityManager;

    @Override
    protected abstract BaseEntityWithTenantRepository getRepository();

    @Override
    public long getSidByTenantAndId(long tenantSid, String id) {
        String sql = String.format("SELECT sid FROM %s WHERE tenant_sid = :tenantSid AND id = :id LIMIT 1", this.getMappingTableName());
        Query query = this.entityManager.createNativeQuery(sql);
        query.setParameter("tenantSid", (Object)tenantSid);
        query.setParameter("id", (Object)id);
        List resultList = query.getResultList();
        if (resultList.size() == 0) {
            return 0L;
        }
        return Long.parseLong(resultList.get(0).toString());
    }

    @Override
    public T findByTenantSidAndId(long tenantSid, String id) {
        return this.getRepository().findByTenantSidAndId(tenantSid, id);
    }

    @Override
    public void deleteByTenantSidAndId(long tenantSid, String id) {
        this.getRepository().deleteByTenantSidAndId(tenantSid, id);
    }

    @Override
    public boolean existsByTenantSidAndId(long tenantSid, String id) {
        return this.getRepository().existsByTenantSidAndId(tenantSid, id);
    }

    @Override
    public void enable(long tenantSid, String id) {
        Object result = this.getRepository().findByTenantSidAndId(tenantSid, id);
        if (result == null) {
            throw new BusinessException("\u6570\u636e\u5df2\u7ecf\u88ab\u5220\u9664.tenantSid:" + tenantSid + ",id:" + id);
        }
        ((BaseEntity)result).setDisabled(false);
        this.getRepository().save(result);
    }

    @Override
    public void disable(long tenantSid, String id) {
        Object result = this.getRepository().findByTenantSidAndId(tenantSid, id);
        if (result == null) {
            throw new BusinessException("\u6570\u636e\u5df2\u7ecf\u88ab\u5220\u9664.tenantSid:" + tenantSid + ",id:" + id);
        }
        ((BaseEntity)result).setDisabled(true);
        this.getRepository().save(result);
    }
}

