package com.digiwin.dap.middleware.util;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.entity.BaseEntityExt;

import java.time.LocalDateTime;

/**
 * 基础字段维护
 *
 * @author fobgochod
 * @since 2.7.20
 */
public class EntityUtils {

    /**
     * 新增数据，基础字段添加默认值
     *
     * @param entity entity
     */
    public static void setCreateFields(BaseEntity entity) {
        // 为空则设置创建字段值
        if (entity.getCreateBy() == null) {
            entity.setCreateBy(UserUtils.getUserSid());
        }
        if (entity.getCreateById() == null) {
            entity.setCreateById(UserUtils.getUserName());
        }
        if (entity.getCreateDate() == null) {
            entity.setCreateDate(LocalDateTime.now());
        }
        entity.setCreateProvider(UserUtils.getSysSid());
        entity.setCreateOrg(0L);
        // 维护扩展基础字段
        if (entity instanceof BaseEntityExt) {
            setCreateFields((BaseEntityExt) entity);
        }
        // 设置修改字段值
        setModifyFields(entity);
    }

    /**
     * 修改数据，基础字段添加默认值
     *
     * @param entity entity
     */
    public static void setModifyFields(BaseEntity entity) {
        // 设置修改字段值
        entity.setModifyBy(UserUtils.getUserSid());
        entity.setModifyById(UserUtils.getUserName());
        entity.setModifyDate(LocalDateTime.now());
        entity.setModifyProvider(UserUtils.getSysSid());
        // 维护扩展基础字段
        if (entity instanceof BaseEntityExt) {
            setModifyFields((BaseEntityExt) entity);
        }
    }

    /**
     * 新增数据，添加创建人ID
     *
     * @param entity entity
     */
    private static void setCreateFields(BaseEntityExt entity) {
        if (entity.getCreatorId() == null) {
            entity.setCreatorId(UserUtils.getUserId());
        }
    }

    /**
     * 修改数据，添加修改人ID
     *
     * @param entity entity
     */
    private static void setModifyFields(BaseEntityExt entity) {
        entity.setModifierId(UserUtils.getUserId());
    }
}
