package com.digiwin.dap.middleware.entity;

import jakarta.persistence.*;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 实体基类
 *
 * @author fobgochod
 * @date 2020/4/27
 */
@MappedSuperclass
public abstract class BaseEntity implements Serializable {

    /**
     * 主键
     */
    @Id
    private long sid;

    /**
     * 创建人sid
     */
    @Column(name = "create_by", columnDefinition = "bigint(20) DEFAULT 0")
    private Long createBy;

    /**
     * 创建人
     */
    @Column(name = "create_by_id")
    private String createById;

    /**
     * 创建时间
     */
    @Column(name = "create_date", columnDefinition = "DATETIME")
    private LocalDateTime createDate;

    /**
     * 应用sid
     */
    @Column(name = "create_provider", columnDefinition = "bigint(20) DEFAULT 0")
    private Long createProvider;

    /**
     * 创建组织
     */
    @Column(name = "create_org", columnDefinition = "bigint(20) DEFAULT 0")
    private Long createOrg;

    /**
     * 修改人sid
     */
    @Column(name = "modify_by", columnDefinition = "bigint(20) DEFAULT 0")
    private Long modifyBy;

    /**
     * 修改人
     */
    @Column(name = "modify_by_id")
    private String modifyById;

    /**
     * 修改日期
     */
    @Column(name = "modify_date", columnDefinition = "DATETIME")
    private LocalDateTime modifyDate;

    /**
     * 应用sid
     */
    @Column(name = "modify_provider", columnDefinition = "bigint(20) DEFAULT 0")
    private Long modifyProvider;

    /**
     * 做乐观锁，修改时hash值必须一致
     */
    @Column(name = "hash", length = 40)
    private String hash;

    /**
     * 是否被禁用
     */
    @Column(name = "disabled", columnDefinition = "bit(1) DEFAULT 0")
    private boolean disabled;

    /**
     * 是否被删除
     */
    @Column(name = "deleted", columnDefinition = "bit(1) DEFAULT 0")
    private boolean deleted;

    public long getSid() {
        return sid;
    }

    public void setSid(long sid) {
        this.sid = sid;
    }

    public Long getCreateBy() {
        return createBy;
    }

    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    public String getCreateById() {
        return createById;
    }

    public void setCreateById(String createById) {
        this.createById = createById;
    }

    public LocalDateTime getCreateDate() {
        return createDate;
    }

    public void setCreateDate(LocalDateTime createDate) {
        this.createDate = createDate;
    }

    public Long getCreateProvider() {
        return createProvider;
    }

    public void setCreateProvider(Long createProvider) {
        this.createProvider = createProvider;
    }

    public Long getCreateOrg() {
        return createOrg;
    }

    public void setCreateOrg(Long createOrg) {
        this.createOrg = createOrg;
    }

    public Long getModifyBy() {
        return modifyBy;
    }

    public void setModifyBy(Long modifyBy) {
        this.modifyBy = modifyBy;
    }

    public String getModifyById() {
        return modifyById;
    }

    public void setModifyById(String modifyById) {
        this.modifyById = modifyById;
    }

    public LocalDateTime getModifyDate() {
        return modifyDate;
    }

    public void setModifyDate(LocalDateTime modifyDate) {
        this.modifyDate = modifyDate;
    }

    public Long getModifyProvider() {
        return modifyProvider;
    }

    public void setModifyProvider(Long modifyProvider) {
        this.modifyProvider = modifyProvider;
    }

    public String getHash() {
        return hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public boolean isDisabled() {
        return disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean isDeleted() {
        return deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }
}
