/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.service.impl;

import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.entity.AssociationEntity;
import com.digiwin.dap.middleware.entity.RelationAssociationEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.service.AssociationEntityService;
import com.digiwin.dap.middleware.service.CascadeDeleteEntityService;
import com.digiwin.dap.middleware.service.RelationAssociationEntityService;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CascadeDeleteEntityServiceImpl
implements CascadeDeleteEntityService {
    @Autowired
    private AssociationEntityService associationEntityService;
    @Autowired
    private RelationAssociationEntityService relationAssociationEntityService;
    @PersistenceContext
    private EntityManager entityManager;

    private static String getSids(List sids) {
        StringBuilder stringBuffer = new StringBuilder();
        for (int i = 0; i < sids.size(); ++i) {
            if (i != sids.size() - 1) {
                stringBuffer.append(sids.get(i)).append(",");
                continue;
            }
            stringBuffer.append(sids.get(i));
        }
        return stringBuffer.toString();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(String name, List<Long> sids) {
        Set<AssociationEntity> entities = this.associationEntityService.getAssociationEntities(name);
        for (AssociationEntity entity : entities) {
            List childSids = this.getSidByTableNameAndField(entity.getTableName(), entity.getFieldName(), sids);
            if (childSids.isEmpty()) continue;
            if (entity.isCascadeDelete()) {
                this.delete(entity.getTableName(), childSids);
                this.deleteByTableNameAndField(entity.getTableName(), entity.getFieldName(), sids);
                continue;
            }
            throw new BusinessException(String.format("\u4e0d\u80fd\u5220\u9664\u8868%s,\u56e0\u4e3a\u8868%s\u5f15\u7528\u4e86\u4e3b\u952e\uff1a%s", name, entity.getTableName(), sids));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteRelation(String tableName, Long masterSid, Long slaveSid) {
        List<RelationAssociationEntity> entities = this.relationAssociationEntityService.getAssociationEntities(tableName);
        entities.forEach(entity -> {
            if (entity.isCheckSelf()) {
                this.deleteRelationByEntityAndCheckSelf((RelationAssociationEntity)entity, masterSid, slaveSid);
            } else {
                this.deleteRelationByEntity((RelationAssociationEntity)entity, masterSid, slaveSid);
            }
        });
    }

    private List getSidByTableNameAndField(String tableName, String fieldName, List<Long> sids) {
        if (StrUtils.isEmpty((String)fieldName)) {
            return Collections.emptyList();
        }
        String sql = String.format("SELECT SID FROM `%s` WHERE %s IN (%s)", tableName, fieldName, CascadeDeleteEntityServiceImpl.getSids(sids));
        return this.entityManager.createNativeQuery(sql).getResultList();
    }

    private void deleteByTableNameAndField(String tableName, String fieldName, List<Long> sids) {
        if (StrUtils.isEmpty((String)fieldName)) {
            return;
        }
        String sql = String.format("DELETE FROM `%s` WHERE %s IN (%s)", tableName, fieldName, CascadeDeleteEntityServiceImpl.getSids(sids));
        this.entityManager.createNativeQuery(sql).executeUpdate();
    }

    private void deleteRelationByEntity(RelationAssociationEntity entity, Long masterSid, Long slaveSid) {
        String sql = String.format("DELETE FROM `%s` WHERE `%s` = %s AND `%s` IN (SELECT sid FROM `%s` WHERE `%s` = %s)", entity.getTableName(), entity.getMasterField(), masterSid, entity.getSlaveField(), entity.getSlaveTable(), entity.getCheckField(), slaveSid);
        this.entityManager.createNativeQuery(sql).executeUpdate();
    }

    private void deleteRelationByEntityAndCheckSelf(RelationAssociationEntity entity, Long masterSid, Long slaveSid) {
        String sql = String.format("DELETE FROM `%s` WHERE `%s` = %s AND `%s` = %s", entity.getTableName(), entity.getMasterField(), masterSid, entity.getCheckField(), slaveSid);
        this.entityManager.createNativeQuery(sql).executeUpdate();
    }
}

