package com.digiwin.dap.middle.cache.limiter.config;

import com.digiwin.dap.middle.cache.limiter.constants.RateLimiterConstant;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.scripting.support.ResourceScriptSource;

@Configuration(proxyBeanMethods = false)
public class LimiterConfig {
    /**
     * 滑动窗口计数算法redis lua 脚本
     *
     * @since 2.7.19.16
     */
    @Bean(name = RateLimiterConstant.SLIDING_WINDOW_RATE_LIMITER_SCRIPT_NAME)
    public RedisScript<Boolean> slidingWindowRateLimiterScript() {
        DefaultRedisScript<Boolean> redisScript = new DefaultRedisScript<>();
        redisScript.setScriptSource(new ResourceScriptSource(new ClassPathResource("META-INF/scripts/sliding_window_rate_limiter.lua")));
        redisScript.setResultType(Boolean.class);
        return redisScript;
    }

    /**
     * 令牌桶算法redis lua 脚本
     *
     * @since 2.7.19.16
     */
    @Bean(name = RateLimiterConstant.TOKEN_BUCKET_RATE_LIMITER_SCRIPT_NAME)
    public RedisScript<Boolean> tokenBucketRateLimiterScript() {
        DefaultRedisScript<Boolean> redisScript = new DefaultRedisScript<>();
        redisScript.setScriptSource(new ResourceScriptSource(new ClassPathResource("META-INF/scripts/token_bucket_rate_limiter.lua")));
        redisScript.setResultType(Boolean.class);
        return redisScript;
    }
}
