package com.digiwin.dap.middle.cache;

import com.digiwin.dap.middleware.util.SnowFlake;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;

/**
 * 基于Redis生成雪花ID机器码(0-{@link SnowFlake#MAX_MACHINE_NUM}，目前最多支持8个实例，基本够用 <br>
 *
 * @author fobgochod
 * @date 2023/12/1 15:50
 */
@Service
class SnowflakeManager {

    private static final Logger logger = LoggerFactory.getLogger(SnowflakeManager.class);

    @Value("${spring.application.name:dap}")
    private String appName;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @PostConstruct
    public void init() {
        String cacheKey = appName + ":snowflake:machineid";
        Long increment = stringRedisTemplate.opsForValue().increment(cacheKey);
        long machineId = increment == null ? 0 : increment & 0x7;
        SnowFlake.getInstance().init(machineId);
        logger.info("SnowFlake.init snowflake machine id is {}", machineId);
    }

    public Long getId() {
        return SnowFlake.getInstance().newId();
    }
}
