/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.cache.limiter;

import com.digiwin.dap.middle.cache.limiter.enums.RateLimitingDimensionEnum;
import com.digiwin.dap.middle.cache.limiter.enums.RateLimitingDimensionOperatorEnum;
import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.util.NetUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.CodeSignature;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class RateLimiterKeyGenerators {
    private static final ExpressionParser parser = new SpelExpressionParser();

    public static List<String> generateRateLimiterKey(Object[] args, Object target, Signature signature, String param, RateLimitingDimensionEnum[] rateLimitingDimensionEnums, RateLimitingDimensionOperatorEnum rateLimitingDimensionOperatorEnum) {
        ArrayList<Object> dimensionList = new ArrayList<Object>();
        String defaultPrefix = "{RateLimiter}" + target.getClass().getName() + "." + signature.getName();
        block7: for (RateLimitingDimensionEnum rateLimitingDimensionEnum : rateLimitingDimensionEnums) {
            switch (rateLimitingDimensionEnum) {
                case TENANT: {
                    if (!StrUtils.isNotEmpty((String)UserUtils.getTenantId())) continue block7;
                    dimensionList.add(UserUtils.getTenantId());
                    continue block7;
                }
                case USER: {
                    if (!StrUtils.isNotEmpty((String)UserUtils.getUserId())) continue block7;
                    dimensionList.add(UserUtils.getUserId());
                    continue block7;
                }
                case SYS: {
                    if (!StrUtils.isNotEmpty((String)UserUtils.getSysId())) continue block7;
                    dimensionList.add(UserUtils.getSysId());
                    continue block7;
                }
                case IP: {
                    dimensionList.add(RateLimiterKeyGenerators.getClientIP());
                    continue block7;
                }
                case CUSTOM_PARAM: {
                    StandardEvaluationContext context = new StandardEvaluationContext();
                    context.setRootObject(target);
                    String[] parameterNames = ((CodeSignature)signature).getParameterNames();
                    for (int i = 0; i < parameterNames.length; ++i) {
                        context.setVariable(parameterNames[i], args[i]);
                    }
                    dimensionList.add(parser.parseExpression(param).getValue((EvaluationContext)context, String.class));
                    continue block7;
                }
            }
        }
        if (rateLimitingDimensionOperatorEnum.equals((Object)RateLimitingDimensionOperatorEnum.OR)) {
            return dimensionList.stream().map(element -> "rate:limiter:" + defaultPrefix + ":" + element).collect(Collectors.toList());
        }
        if (rateLimitingDimensionOperatorEnum.equals((Object)RateLimitingDimensionOperatorEnum.AND)) {
            return Collections.singletonList("rate:limiter:" + defaultPrefix + ":" + String.join((CharSequence)":", dimensionList));
        }
        return Collections.emptyList();
    }

    private static String getServletPath() {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = Objects.requireNonNull(attributes).getRequest();
        return request.getServletPath();
    }

    private static String getClientIP() {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = Objects.requireNonNull(attributes).getRequest();
        return NetUtils.getClientIP((HttpServletRequest)request);
    }
}

