package com.digiwin.dap.middle.cache.limiter.callback;

import com.digiwin.dap.middleware.domain.CommonErrorCode;
import com.digiwin.dap.middleware.exception.RequestNotPermittedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author michael
 * @since 2.7.19.16
 */
public abstract class AbstractRateLimiterCallback implements RateLimiterCallback {

    private static final Logger logger = LoggerFactory.getLogger(AbstractRateLimiterCallback.class);

    public AbstractRateLimiterCallback() {
    }

    @Override
    public void onRateLimited() {
        throw new RequestNotPermittedException(CommonErrorCode.TOO_MANY_REQUESTS);
    }
}
