package com.digiwin.dap.middle.cache.limiter.annotation;

import com.digiwin.dap.middle.cache.limiter.callback.AbstractRateLimiterCallback;
import com.digiwin.dap.middle.cache.limiter.enums.RateLimitingDimensionEnum;
import com.digiwin.dap.middle.cache.limiter.enums.RateLimitingDimensionOperatorEnum;

import java.lang.annotation.*;

/**
 * <p>滑动窗口计数算法</p>
 * <p>滑动窗口计数：滑动窗口是一种基于时间窗口的限流算法。它将时间划分为连续的窗口（通常是小窗口），并在这些窗口上统计请求次数。
 * 滑动窗口可以通过在窗口内平滑统计请求来解决固定窗口算法的“临界突发”问题。</p>
 * <p>特点：严格的时间窗口、精确控制流量、近似精确</p>
 * <p>优点：</p><p>1、对于需要严格限制请求频率的场景，滑动窗口比令牌桶算法更加精确；2、适用于防止恶意攻击的场景，例如防止暴力破解密码的请求</p>
 * <p>缺点：</p><p>1、对于需要支持突发流量的场景，可能不太合适，因为它会严格限制请求频率，不允许超过设定的最大值；2、计算复杂度较高，尤其是在需要精确控制的情况下</p>
 * <p>接口处理能力=maxRequests/windowSize</p>
 *
 * @author michael
 * @since 2.7.19.16
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Inherited
public @interface SlidingWindowRateLimiter {

    /**
     * 窗口内最大请求量
     */
    int maxRequests();


    /**
     * 窗口大小,单位:秒
     */
    long windowSize();

    /**
     * 限流自定义参数,支持SpEL,当限流维度设置CUSTOM_PARAM时使用
     */
    String param() default "";

    /**
     * 限流回调
     */
    Class<? extends AbstractRateLimiterCallback> callback() default AbstractRateLimiterCallback.class;

    /**
     * 限流维度
     */
    RateLimitingDimensionEnum[] dimensions() default {RateLimitingDimensionEnum.UNDEFINED};

    /**
     * 多个限流维度运算符
     */
    RateLimitingDimensionOperatorEnum operator() default RateLimitingDimensionOperatorEnum.OR;
}
