/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.cache.limiter.aspect;

import com.digiwin.dap.middle.cache.limiter.RateLimiter;
import com.digiwin.dap.middle.cache.limiter.RateLimiterKeyGenerators;
import com.digiwin.dap.middle.cache.limiter.callback.AbstractRateLimiterCallback;
import com.digiwin.dap.middle.cache.limiter.callback.RateLimiterCallback;
import com.digiwin.dap.middleware.domain.CommonErrorCode;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.RequestNotPermittedException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Aspect
@Component
public class TokenBucketRateLimiterInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(TokenBucketRateLimiterInterceptor.class);
    private final RedisTemplate<String, Object> redisTemplate;
    private final RedisScript<Boolean> script;
    @Value(value="${spring.application.name:dap}")
    private String appName;
    @Value(value="${dap.middleware.rate.limiter:true}")
    private boolean rateLimiter;

    public TokenBucketRateLimiterInterceptor(RedisTemplate<String, Object> redisTemplate, @Qualifier(value="tokenBucketRateLimiterScript") RedisScript<Boolean> script) {
        this.redisTemplate = redisTemplate;
        this.script = script;
    }

    @Before(value="(@annotation(com.digiwin.dap.middle.cache.limiter.RateLimiter))")
    public void execute(JoinPoint joinPoint) {
        if (!this.rateLimiter) {
            return;
        }
        Boolean allowed = true;
        Class<? extends AbstractRateLimiterCallback> callbackClass = null;
        try {
            String key;
            RateLimiter rateLimiter = ((MethodSignature)joinPoint.getSignature()).getMethod().getAnnotation(RateLimiter.class);
            int replenishRate = rateLimiter.replenishRate();
            int burstCapacity = rateLimiter.burstCapacity();
            int requestedTokens = rateLimiter.requestedTokens();
            callbackClass = rateLimiter.callback();
            List<String> keyList = RateLimiterKeyGenerators.generateRateLimiterKey(joinPoint.getArgs(), joinPoint.getTarget(), joinPoint.getSignature(), rateLimiter.param(), rateLimiter.dimensions(), rateLimiter.operator());
            if (CollectionUtils.isEmpty(keyList)) {
                throw new RequestNotPermittedException((ErrorHandler)CommonErrorCode.TOO_MANY_REQUESTS);
            }
            keyList = keyList.stream().map(element -> this.appName + ":token:bucket:" + element).collect(Collectors.toList());
            Iterator<String> iterator = keyList.iterator();
            while (iterator.hasNext() && (allowed = (Boolean)this.redisTemplate.execute(this.script, Collections.singletonList(key = iterator.next()), new Object[]{burstCapacity, replenishRate, requestedTokens})) != null && allowed.booleanValue()) {
            }
        }
        catch (Exception e) {
            logger.error("Error determining if user allowed from redis", (Throwable)e);
        }
        if (allowed == null || !allowed.booleanValue()) {
            RateLimiterCallback rateLimiterCallback = null;
            try {
                rateLimiterCallback = (RateLimiterCallback)callbackClass.newInstance();
            }
            catch (Exception e) {
                logger.error("rate limited callback error", (Throwable)e);
            }
            if (rateLimiterCallback != null) {
                rateLimiterCallback.onRateLimited();
            } else {
                throw new RequestNotPermittedException((ErrorHandler)CommonErrorCode.TOO_MANY_REQUESTS);
            }
        }
    }
}

