/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.database.encrypt.config;

import com.digiwin.dap.middle.database.encrypt.condition.DatabaseEncryptedStorageCondition;
import com.digiwin.dap.middle.database.encrypt.desensitization.register.DesensitizationProcessorRegistry;
import com.digiwin.dap.middle.database.encrypt.desensitization.service.DesensitizationConverter;
import com.digiwin.dap.middle.database.encrypt.desensitization.service.impl.DesensitizationConverterImpl;
import com.digiwin.dap.middle.database.encrypt.sensitive.word.register.DefaultSensitiveWordDatabaseRegistry;
import com.digiwin.dap.middle.database.encrypt.sensitive.word.register.SensitiveWordDatabaseRegistry;
import com.digiwin.dap.middle.database.encrypt.sql.parser.SqlParser;
import com.digiwin.dap.middle.database.encrypt.sql.parser.impl.CCJSqlParserImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@Conditional(value={DatabaseEncryptedStorageCondition.class})
public class DatabaseEncryptConfig {
    @Autowired
    private Environment environment;
    @Autowired
    @Qualifier(value="desensitizationProcessorRegistry")
    private DesensitizationProcessorRegistry desensitizationProcessorRegistry;

    @Bean(value={"sensitiveWordDatabase"})
    public SensitiveWordDatabaseRegistry sensitiveWordDatabaseRegistry() {
        return new DefaultSensitiveWordDatabaseRegistry(this.environment);
    }

    @Bean(value={"desensitizationConverter"})
    public DesensitizationConverter<Object> desensitizationConverter() {
        return new DesensitizationConverterImpl<Object>(this.sensitiveWordDatabaseRegistry(), this.desensitizationProcessorRegistry);
    }

    @Bean(value={"sqlParser"})
    public SqlParser sqlParser() {
        return new CCJSqlParserImpl();
    }
}

