/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.database.encrypt.sql.parser.impl;

import com.digiwin.dap.middle.database.encrypt.enums.DatabaseEncryptExceptionEnum;
import com.digiwin.dap.middle.database.encrypt.exception.DatabaseEncryptException;
import com.digiwin.dap.middle.database.encrypt.model.ObjectRelationalMapping;
import com.digiwin.dap.middle.database.encrypt.sql.parser.SqlParser;
import com.digiwin.dap.middleware.commons.util.StrUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.SelectVisitorAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CCJSqlParserImpl
implements SqlParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(CCJSqlParserImpl.class);
    private static final String MYSQL_DIALECT = "`";
    private final Map<String, List<ObjectRelationalMapping>> mappingMap = new ConcurrentHashMap<String, List<ObjectRelationalMapping>>();

    private static List<ObjectRelationalMapping> parseResultSetFromStatement(Select select, final List<TableInfo> tableInfoList) {
        final ArrayList<ObjectRelationalMapping> objectRelationalMappings = new ArrayList<ObjectRelationalMapping>();
        select.accept((SelectVisitor)new SelectVisitorAdapter<Void>(){

            public <S> Void visit(PlainSelect plainSelect, S context) {
                List selectItems = plainSelect.getSelectItems();
                for (SelectItem selectItem : selectItems) {
                    Expression expression = selectItem.getExpression();
                    if (expression instanceof Column) {
                        String expressionString = expression.toString();
                        String aliasTableName = expressionString.contains(".") ? expressionString.substring(0, expressionString.indexOf(".")) : "";
                        String columnName = expressionString.contains(".") ? expressionString.substring(expressionString.indexOf(".") + 1) : expressionString;
                        String aliasColumnName = selectItem.getAlias() != null ? selectItem.getAlias().getName() : columnName;
                        String tableName = StrUtils.isNotEmpty((String)aliasTableName) ? tableInfoList.stream().filter(x -> Objects.equals(x.getAliasTableName(), aliasTableName)).findFirst().get().getTableName().toLowerCase() : ((TableInfo)tableInfoList.get(0)).getTableName().toLowerCase();
                        columnName = columnName.replaceAll(CCJSqlParserImpl.MYSQL_DIALECT, "");
                        aliasColumnName = aliasColumnName.replaceAll(CCJSqlParserImpl.MYSQL_DIALECT, "");
                        objectRelationalMappings.add(new ObjectRelationalMapping(tableName, columnName, aliasColumnName));
                        LOGGER.debug("====>\u6570\u636e\u5e93\u3010{}\u3011\u8868,\u5b57\u6bb5\u3010{}\u3011,\u6620\u5c04\u5230\u5bf9\u8c61\u4e2d\u5c5e\u6027\u540d\u4e3a\u3010{}\u3011", new Object[]{tableName, columnName, aliasColumnName});
                        continue;
                    }
                    LOGGER.debug("====>\u5217\u3010{}\u3011\u6682\u4e0d\u652f\u6301\u89e3\u6790", (Object)expression);
                }
                return null;
            }
        }, null);
        return objectRelationalMappings;
    }

    private static List<TableInfo> parseTableFromStatement(Statement statement) {
        final ArrayList<TableInfo> tableInfoList = new ArrayList<TableInfo>();
        if (statement instanceof Select) {
            Select select = (Select)statement;
            select.accept((SelectVisitor)new SelectVisitorAdapter<Void>(){

                public <S> Void visit(PlainSelect plainSelect, S context) {
                    FromItem fromItem = plainSelect.getFromItem();
                    if (fromItem instanceof Table) {
                        Table table = (Table)fromItem;
                        String tableName = table.getName();
                        String[] parts = tableName.split("\\s+");
                        tableName = parts[0];
                        tableName = tableName.replaceAll(CCJSqlParserImpl.MYSQL_DIALECT, "");
                        String aliasTableName = table.getAlias() != null ? table.getAlias().getName() : tableName;
                        aliasTableName = aliasTableName.replaceAll(CCJSqlParserImpl.MYSQL_DIALECT, "");
                        tableInfoList.add(new TableInfo(tableName, aliasTableName));
                    }
                    if (plainSelect.getJoins() != null) {
                        for (Join join : plainSelect.getJoins()) {
                            FromItem joinItem = join.getRightItem();
                            if (!(joinItem instanceof Table)) continue;
                            Table table = (Table)joinItem;
                            String tableName = table.getName();
                            String[] parts = tableName.split("\\s+");
                            tableName = parts[0];
                            tableName = tableName.replaceAll(CCJSqlParserImpl.MYSQL_DIALECT, "");
                            String aliasTableName = table.getAlias() != null ? table.getAlias().getName() : tableName;
                            aliasTableName = aliasTableName.replaceAll(CCJSqlParserImpl.MYSQL_DIALECT, "");
                            tableInfoList.add(new TableInfo(tableName, aliasTableName));
                        }
                    }
                    return null;
                }
            }, null);
        }
        return tableInfoList;
    }

    @Override
    public List<ObjectRelationalMapping> parseQuerySql(String id, String sql) {
        List<ObjectRelationalMapping> objectRelationalMappings = new ArrayList<ObjectRelationalMapping>();
        if (this.mappingMap.containsKey(id)) {
            return this.mappingMap.get(id);
        }
        try {
            Statement statement = CCJSqlParserUtil.parse((String)sql);
            if (!(statement instanceof Select)) {
                LOGGER.debug("====>sql\u89e3\u6790,\u6682\u4e0d\u652f\u6301\u89e3\u6790\u975eselect\u8bed\u53e5");
                return objectRelationalMappings;
            }
            List<TableInfo> tableInfoList = CCJSqlParserImpl.parseTableFromStatement(statement);
            objectRelationalMappings = CCJSqlParserImpl.parseResultSetFromStatement((Select)statement, tableInfoList);
        }
        catch (Exception e) {
            if (e instanceof JSQLParserException) {
                LOGGER.error("====>\u89e3\u6790sql\u5f02\u5e38:\u3010{}\u3011", (Object)sql);
            }
            LOGGER.error("====>\u89e3\u6790sql\u83b7\u53d6\u7ed3\u679c\u5217\u5f02\u5e38,\u5f02\u5e38sql:\u3010{}\u3011", (Object)sql);
            throw new DatabaseEncryptException(DatabaseEncryptExceptionEnum.PARSE_SQL, sql);
        }
        this.mappingMap.put(id, objectRelationalMappings);
        return objectRelationalMappings;
    }

    static class TableInfo {
        private final String tableName;
        private final String aliasTableName;

        public TableInfo(String tableName, String aliasTableName) {
            this.tableName = tableName;
            this.aliasTableName = aliasTableName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String getAliasTableName() {
            return this.aliasTableName;
        }
    }
}

